/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.repository.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import net.sf.beanlib.provider.replicator.BeanReplicator;
import org.apache.archiva.admin.model.AuditInformation;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.admin.ArchivaAdministration;
import org.apache.archiva.admin.model.beans.FileType;
import org.apache.archiva.admin.model.beans.NetworkConfiguration;
import org.apache.archiva.admin.model.beans.UiConfiguration;
import org.apache.archiva.admin.repository.AbstractRepositoryAdmin;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.LegacyArtifactPath;
import org.apache.archiva.configuration.OrganisationInformation;
import org.apache.archiva.configuration.UserInterfaceOptions;
import org.apache.archiva.configuration.WebappConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="archivaAdministration#default")
public class DefaultArchivaAdministration
extends AbstractRepositoryAdmin
implements ArchivaAdministration {
    @PostConstruct
    public void initialize() throws RepositoryAdminException {
        NetworkConfiguration networkConfiguration = this.getNetworkConfiguration();
        this.setupWagon(networkConfiguration);
    }

    public List<org.apache.archiva.admin.model.beans.LegacyArtifactPath> getLegacyArtifactPaths() throws RepositoryAdminException {
        ArrayList<org.apache.archiva.admin.model.beans.LegacyArtifactPath> legacyArtifactPaths = new ArrayList<org.apache.archiva.admin.model.beans.LegacyArtifactPath>();
        for (LegacyArtifactPath legacyArtifactPath : this.getArchivaConfiguration().getConfiguration().getLegacyArtifactPaths()) {
            legacyArtifactPaths.add((org.apache.archiva.admin.model.beans.LegacyArtifactPath)new BeanReplicator().replicateBean((Object)legacyArtifactPath, org.apache.archiva.admin.model.beans.LegacyArtifactPath.class));
        }
        return legacyArtifactPaths;
    }

    public void addLegacyArtifactPath(org.apache.archiva.admin.model.beans.LegacyArtifactPath legacyArtifactPath, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        configuration.addLegacyArtifactPath((LegacyArtifactPath)new BeanReplicator().replicateBean((Object)legacyArtifactPath, LegacyArtifactPath.class));
        this.saveConfiguration(configuration);
        this.triggerAuditEvent("", "", "Added Legacy Artifact Path", auditInformation);
    }

    public void deleteLegacyArtifactPath(String path, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        LegacyArtifactPath legacyArtifactPath = new LegacyArtifactPath();
        legacyArtifactPath.setPath(path);
        configuration.removeLegacyArtifactPath(legacyArtifactPath);
        this.saveConfiguration(configuration);
        this.triggerAuditEvent("", "", "Removed Legacy Artifact Path", auditInformation);
    }

    public void addFileTypePattern(String fileTypeId, String pattern, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        org.apache.archiva.configuration.FileType fileType = this.getFileTypeById(fileTypeId, configuration);
        if (fileType == null) {
            return;
        }
        if (fileType.getPatterns().contains(pattern)) {
            throw new RepositoryAdminException("File type [" + fileTypeId + "] already contains pattern [" + pattern + "]");
        }
        fileType.addPattern(pattern);
        this.saveConfiguration(configuration);
        this.triggerAuditEvent("", "", "Added File Type Pattern", auditInformation);
    }

    public void removeFileTypePattern(String fileTypeId, String pattern, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        org.apache.archiva.configuration.FileType fileType = this.getFileTypeById(fileTypeId, configuration);
        if (fileType == null) {
            return;
        }
        fileType.removePattern(pattern);
        this.saveConfiguration(configuration);
        this.triggerAuditEvent("", "", "Removed File Type Pattern", auditInformation);
    }

    public FileType getFileType(String fileTypeId) throws RepositoryAdminException {
        org.apache.archiva.configuration.FileType fileType = this.getFileTypeById(fileTypeId, this.getArchivaConfiguration().getConfiguration());
        if (fileType == null) {
            return null;
        }
        return (FileType)new BeanReplicator().replicateBean((Object)fileType, FileType.class);
    }

    public void addFileType(FileType fileType, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        if (this.getFileTypeById(fileType.getId(), configuration) != null) {
            throw new RepositoryAdminException("impossible to FileType with id " + fileType.getId() + " already exists");
        }
        configuration.getRepositoryScanning().addFileType((org.apache.archiva.configuration.FileType)new BeanReplicator().replicateBean((Object)fileType, org.apache.archiva.configuration.FileType.class));
        this.saveConfiguration(configuration);
    }

    public void removeFileType(String fileTypeId, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        org.apache.archiva.configuration.FileType fileType = new org.apache.archiva.configuration.FileType();
        fileType.setId(fileTypeId);
        configuration.getRepositoryScanning().removeFileType(fileType);
        this.saveConfiguration(configuration);
    }

    public void addKnownContentConsumer(String knownContentConsumer, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        if (configuration.getRepositoryScanning().getKnownContentConsumers().contains(knownContentConsumer)) {
            this.log.warn("skip adding knownContentConsumer {} as already here", (Object)knownContentConsumer);
            return;
        }
        configuration.getRepositoryScanning().addKnownContentConsumer(knownContentConsumer);
        this.saveConfiguration(configuration);
        this.triggerAuditEvent("", "", "Enabled Content Consumer", auditInformation);
    }

    public void removeKnownContentConsumer(String knownContentConsumer, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        configuration.getRepositoryScanning().removeKnownContentConsumer(knownContentConsumer);
        this.saveConfiguration(configuration);
        this.triggerAuditEvent("", "", "Disabled Content Consumer", auditInformation);
    }

    public void addInvalidContentConsumer(String invalidContentConsumer, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        if (configuration.getRepositoryScanning().getInvalidContentConsumers().contains(invalidContentConsumer)) {
            this.log.warn("skip adding invalidContentConsumer {} as already here", (Object)invalidContentConsumer);
            return;
        }
        configuration.getRepositoryScanning().addInvalidContentConsumer(invalidContentConsumer);
        this.saveConfiguration(configuration);
        this.triggerAuditEvent("", "", "Enabled Content Consumer", auditInformation);
    }

    public void removeInvalidContentConsumer(String invalidContentConsumer, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        configuration.getRepositoryScanning().removeInvalidContentConsumer(invalidContentConsumer);
        this.saveConfiguration(configuration);
        this.triggerAuditEvent("", "", "Disabled Content Consumer", auditInformation);
    }

    public void setKnownContentConsumers(List<String> knownContentConsumers, AuditInformation auditInformation) throws RepositoryAdminException {
        if (knownContentConsumers == null) {
            return;
        }
        for (String knowContentConsumer : knownContentConsumers) {
            this.addKnownContentConsumer(knowContentConsumer, auditInformation);
        }
    }

    public void setInvalidContentConsumers(List<String> invalidContentConsumers, AuditInformation auditInformation) throws RepositoryAdminException {
        if (invalidContentConsumers == null) {
            return;
        }
        for (String invalidContentConsumer : invalidContentConsumers) {
            this.addKnownContentConsumer(invalidContentConsumer, auditInformation);
        }
    }

    public List<FileType> getFileTypes() throws RepositoryAdminException {
        List configFileTypes = this.getArchivaConfiguration().getConfiguration().getRepositoryScanning().getFileTypes();
        if (configFileTypes == null || configFileTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FileType> fileTypes = new ArrayList<FileType>();
        for (org.apache.archiva.configuration.FileType fileType : configFileTypes) {
            fileTypes.add((FileType)new BeanReplicator().replicateBean((Object)fileType, FileType.class));
        }
        return fileTypes;
    }

    public List<String> getKnownContentConsumers() throws RepositoryAdminException {
        return new ArrayList<String>(this.getArchivaConfiguration().getConfiguration().getRepositoryScanning().getKnownContentConsumers());
    }

    public List<String> getInvalidContentConsumers() throws RepositoryAdminException {
        return new ArrayList<String>(this.getArchivaConfiguration().getConfiguration().getRepositoryScanning().getInvalidContentConsumers());
    }

    public org.apache.archiva.admin.model.beans.OrganisationInformation getOrganisationInformation() throws RepositoryAdminException {
        OrganisationInformation organisationInformation = this.getArchivaConfiguration().getConfiguration().getOrganisationInfo();
        if (organisationInformation == null) {
            return null;
        }
        return (org.apache.archiva.admin.model.beans.OrganisationInformation)new BeanReplicator().replicateBean((Object)organisationInformation, org.apache.archiva.admin.model.beans.OrganisationInformation.class);
    }

    public void setOrganisationInformation(org.apache.archiva.admin.model.beans.OrganisationInformation organisationInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        if (organisationInformation != null) {
            OrganisationInformation organisationInformationModel = (OrganisationInformation)new BeanReplicator().replicateBean((Object)organisationInformation, OrganisationInformation.class);
            configuration.setOrganisationInfo(organisationInformationModel);
        } else {
            configuration.setOrganisationInfo(null);
        }
        this.saveConfiguration(configuration);
    }

    public UiConfiguration getUiConfiguration() throws RepositoryAdminException {
        WebappConfiguration webappConfiguration = this.getArchivaConfiguration().getConfiguration().getWebapp();
        if (webappConfiguration == null) {
            return null;
        }
        UserInterfaceOptions userInterfaceOptions = webappConfiguration.getUi();
        if (userInterfaceOptions == null) {
            return null;
        }
        return (UiConfiguration)new BeanReplicator().replicateBean((Object)userInterfaceOptions, UiConfiguration.class);
    }

    public void updateUiConfiguration(UiConfiguration uiConfiguration) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        if (uiConfiguration != null) {
            UserInterfaceOptions userInterfaceOptions = (UserInterfaceOptions)new BeanReplicator().replicateBean((Object)uiConfiguration, UserInterfaceOptions.class);
            configuration.getWebapp().setUi(userInterfaceOptions);
        } else {
            configuration.getWebapp().setUi(null);
        }
        this.saveConfiguration(configuration);
    }

    public NetworkConfiguration getNetworkConfiguration() throws RepositoryAdminException {
        org.apache.archiva.configuration.NetworkConfiguration networkConfiguration = this.getArchivaConfiguration().getConfiguration().getNetworkConfiguration();
        if (networkConfiguration == null) {
            return null;
        }
        return (NetworkConfiguration)new BeanReplicator().replicateBean((Object)networkConfiguration, NetworkConfiguration.class);
    }

    public void setNetworkConfiguration(NetworkConfiguration networkConfiguration) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        if (networkConfiguration == null) {
            configuration.setNetworkConfiguration(null);
        } else {
            configuration.setNetworkConfiguration((org.apache.archiva.configuration.NetworkConfiguration)new BeanReplicator().replicateBean((Object)networkConfiguration, org.apache.archiva.configuration.NetworkConfiguration.class));
        }
        this.setupWagon(networkConfiguration);
        this.saveConfiguration(configuration);
    }

    protected void setupWagon(NetworkConfiguration networkConfiguration) {
        if (networkConfiguration == null) {
            HttpWagon.setUseClientManagerPooled((boolean)true);
            ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager();
            threadSafeClientConnManager.setDefaultMaxPerRoute(30);
            threadSafeClientConnManager.setMaxTotal(30);
            HttpWagon.setConnectionManagerPooled((ClientConnectionManager)threadSafeClientConnManager);
        } else {
            HttpWagon.setUseClientManagerPooled((boolean)networkConfiguration.isUsePooling());
            ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager();
            threadSafeClientConnManager.setDefaultMaxPerRoute(networkConfiguration.getMaxTotalPerHost());
            threadSafeClientConnManager.setMaxTotal(networkConfiguration.getMaxTotal());
            HttpWagon.setConnectionManagerPooled((ClientConnectionManager)threadSafeClientConnManager);
        }
    }

    private org.apache.archiva.configuration.FileType getFileTypeById(String id, Configuration configuration) {
        for (org.apache.archiva.configuration.FileType fileType : configuration.getRepositoryScanning().getFileTypes()) {
            if (!StringUtils.equals((String)id, (String)fileType.getId())) continue;
            return fileType;
        }
        return null;
    }
}

