/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.repository;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.AbstractRepository;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.GenericValidator;
import org.codehaus.plexus.registry.Registry;
import org.springframework.stereotype.Service;

@Service
public class RepositoryCommonValidator {
    public static final String REPOSITORY_ID_VALID_EXPRESSION = "^[a-zA-Z0-9._-]+$";
    public static final String REPOSITORY_NAME_VALID_EXPRESSION = "^([a-zA-Z0-9.)/_(-]|\\s)+$";
    @Inject
    private ArchivaConfiguration archivaConfiguration;
    @Inject
    @Named(value="commons-configuration")
    private Registry registry;

    public void basicValidation(AbstractRepository abstractRepository, boolean update) throws RepositoryAdminException {
        Configuration config = this.archivaConfiguration.getConfiguration();
        String repoId = abstractRepository.getId();
        if (!update) {
            if (config.getManagedRepositoriesAsMap().containsKey(repoId)) {
                throw new RepositoryAdminException("Unable to add new repository with id [" + repoId + "], that id already exists as a managed repository.");
            }
            if (config.getRepositoryGroupsAsMap().containsKey(repoId)) {
                throw new RepositoryAdminException("Unable to add new repository with id [" + repoId + "], that id already exists as a repository group.");
            }
            if (config.getRemoteRepositoriesAsMap().containsKey(repoId)) {
                throw new RepositoryAdminException("Unable to add new repository with id [" + repoId + "], that id already exists as a remote repository.");
            }
        }
        if (StringUtils.isBlank((String)repoId)) {
            throw new RepositoryAdminException("Repository ID cannot be empty.");
        }
        if (!GenericValidator.matchRegexp((String)repoId, (String)REPOSITORY_ID_VALID_EXPRESSION)) {
            throw new RepositoryAdminException("Invalid repository ID. Identifier must only contain alphanumeric characters, underscores(_), dots(.), and dashes(-).");
        }
        String name = abstractRepository.getName();
        if (StringUtils.isBlank((String)name)) {
            throw new RepositoryAdminException("repository name cannot be empty");
        }
        if (!GenericValidator.matchRegexp((String)name, (String)REPOSITORY_NAME_VALID_EXPRESSION)) {
            throw new RepositoryAdminException("Invalid repository name. Repository Name must only contain alphanumeric characters, white-spaces(' '), forward-slashes(/), open-parenthesis('('), close-parenthesis(')'),  underscores(_), dots(.), and dashes(-).");
        }
    }

    public String removeExpressions(String directory) {
        String value = StringUtils.replace((String)directory, (String)"${appserver.base}", (String)this.getRegistry().getString("appserver.base", "${appserver.base}"));
        value = StringUtils.replace((String)value, (String)"${appserver.home}", (String)this.getRegistry().getString("appserver.home", "${appserver.home}"));
        return value;
    }

    public ArchivaConfiguration getArchivaConfiguration() {
        return this.archivaConfiguration;
    }

    public void setArchivaConfiguration(ArchivaConfiguration archivaConfiguration) {
        this.archivaConfiguration = archivaConfiguration;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

