/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.repository;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.AuditInformation;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.repository.RepositoryCommonValidator;
import org.apache.archiva.audit.AuditEvent;
import org.apache.archiva.audit.AuditListener;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.IndeterminateConfigurationException;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.registry.Registry;
import org.codehaus.plexus.registry.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryAdmin {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private List<AuditListener> auditListeners = new ArrayList<AuditListener>();
    @Inject
    private RepositoryCommonValidator repositoryCommonValidator;
    @Inject
    private ArchivaConfiguration archivaConfiguration;
    @Inject
    @Named(value="commons-configuration")
    private Registry registry;

    protected void triggerAuditEvent(String repositoryId, String resource, String action, AuditInformation auditInformation) {
        User user = auditInformation == null ? null : auditInformation.getUser();
        AuditEvent event = new AuditEvent(repositoryId, user == null ? "null" : (String)user.getPrincipal(), resource, action);
        event.setRemoteIP(auditInformation == null ? "null" : auditInformation.getRemoteAddr());
        for (AuditListener listener : this.getAuditListeners()) {
            listener.auditEvent(event);
        }
    }

    protected void saveConfiguration(Configuration config) throws RepositoryAdminException {
        try {
            this.getArchivaConfiguration().save(config);
        }
        catch (RegistryException e) {
            throw new RepositoryAdminException("Error occurred in the registry: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IndeterminateConfigurationException e) {
            throw new RepositoryAdminException("Error occurred while saving the configuration: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public List<AuditListener> getAuditListeners() {
        return this.auditListeners;
    }

    public void setAuditListeners(List<AuditListener> auditListeners) {
        this.auditListeners = auditListeners;
    }

    public void setArchivaConfiguration(ArchivaConfiguration archivaConfiguration) {
        this.archivaConfiguration = archivaConfiguration;
    }

    public ArchivaConfiguration getArchivaConfiguration() {
        return this.archivaConfiguration;
    }

    public RepositoryCommonValidator getRepositoryCommonValidator() {
        return this.repositoryCommonValidator;
    }

    public void setRepositoryCommonValidator(RepositoryCommonValidator repositoryCommonValidator) {
        this.repositoryCommonValidator = repositoryCommonValidator;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

