/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.proxy;

import java.util.List;
import java.util.Map;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.RemoteRepositoryContent;
import org.apache.archiva.repository.connector.RepositoryConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyConnector
implements RepositoryConnector {
    private ManagedRepositoryContent sourceRepository;
    private RemoteRepositoryContent targetRepository;
    private List<String> blacklist;
    private List<String> whitelist;
    private String proxyId;
    private int order;
    private Map<String, String> policies;
    private boolean disabled;

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public List<String> getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(List<String> blacklist) {
        this.blacklist = blacklist;
    }

    public ManagedRepositoryContent getSourceRepository() {
        return this.sourceRepository;
    }

    public void setSourceRepository(ManagedRepositoryContent sourceRepository) {
        this.sourceRepository = sourceRepository;
    }

    public RemoteRepositoryContent getTargetRepository() {
        return this.targetRepository;
    }

    public void setTargetRepository(RemoteRepositoryContent targetRepository) {
        this.targetRepository = targetRepository;
    }

    public List<String> getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(List<String> whitelist) {
        this.whitelist = whitelist;
    }

    public Map<String, String> getPolicies() {
        return this.policies;
    }

    public void setPolicies(Map<String, String> policies) {
        this.policies = policies;
    }

    public String getProxyId() {
        return this.proxyId;
    }

    public void setProxyId(String proxyId) {
        this.proxyId = proxyId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ProxyConnector[\n");
        sb.append("  source: [managed] ").append(this.sourceRepository.getRepoRoot()).append("\n");
        sb.append("  target: [remote] ").append(this.targetRepository.getRepository().getUrl()).append("\n");
        sb.append("  proxyId:").append(this.proxyId).append("\n");
        for (String name : this.policies.keySet()) {
            sb.append("  policy[").append(name).append("]:");
            sb.append(this.policies.get(name)).append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public void setPolicy(String policyId, String policySetting) {
        this.policies.put(policyId, policySetting);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

