/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.proxy;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.ConfigurationNames;
import org.apache.archiva.configuration.NetworkProxyConfiguration;
import org.apache.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.Keys;
import org.apache.archiva.model.RepositoryURL;
import org.apache.archiva.policies.DownloadErrorPolicy;
import org.apache.archiva.policies.DownloadPolicy;
import org.apache.archiva.policies.PolicyConfigurationException;
import org.apache.archiva.policies.PolicyViolationException;
import org.apache.archiva.policies.PostDownloadPolicy;
import org.apache.archiva.policies.PreDownloadPolicy;
import org.apache.archiva.policies.ProxyDownloadException;
import org.apache.archiva.policies.urlcache.UrlFailureCache;
import org.apache.archiva.proxy.NotFoundException;
import org.apache.archiva.proxy.NotModifiedException;
import org.apache.archiva.proxy.ProxyConnector;
import org.apache.archiva.proxy.ProxyConnectorOrderComparator;
import org.apache.archiva.proxy.ProxyException;
import org.apache.archiva.proxy.RepositoryProxyConnectors;
import org.apache.archiva.proxy.common.WagonFactory;
import org.apache.archiva.proxy.common.WagonFactoryException;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.RemoteRepositoryContent;
import org.apache.archiva.repository.RepositoryContentFactory;
import org.apache.archiva.repository.RepositoryException;
import org.apache.archiva.repository.RepositoryNotFoundException;
import org.apache.archiva.repository.metadata.MetadataTools;
import org.apache.archiva.repository.metadata.RepositoryMetadataException;
import org.apache.archiva.scheduler.ArchivaTaskScheduler;
import org.apache.archiva.scheduler.repository.RepositoryTask;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.registry.Registry;
import org.codehaus.plexus.registry.RegistryListener;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.TaskQueueException;
import org.codehaus.plexus.util.SelectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="repositoryProxyConnectors#default")
public class DefaultRepositoryProxyConnectors
implements RepositoryProxyConnectors,
RegistryListener {
    private Logger log = LoggerFactory.getLogger(DefaultRepositoryProxyConnectors.class);
    @Inject
    @Named(value="archivaConfiguration#default")
    private ArchivaConfiguration archivaConfiguration;
    @Inject
    @Named(value="repositoryContentFactory#default")
    private RepositoryContentFactory repositoryFactory;
    @Inject
    @Named(value="metadataTools#default")
    private MetadataTools metadataTools;
    @Inject
    private Map<String, PreDownloadPolicy> preDownloadPolicies;
    @Inject
    private Map<String, PostDownloadPolicy> postDownloadPolicies;
    @Inject
    private Map<String, DownloadErrorPolicy> downloadErrorPolicies;
    @Inject
    private UrlFailureCache urlFailureCache;
    private Map<String, List<ProxyConnector>> proxyConnectorMap = new HashMap<String, List<ProxyConnector>>();
    private Map<String, ProxyInfo> networkProxyMap = new HashMap<String, ProxyInfo>();
    @Inject
    private WagonFactory wagonFactory;
    @Inject
    @Named(value="archivaTaskScheduler#repository")
    private ArchivaTaskScheduler scheduler;

    @PostConstruct
    public void initialize() {
        this.initConnectorsAndNetworkProxies();
        this.archivaConfiguration.addChangeListener((RegistryListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnectorsAndNetworkProxies() {
        Map<String, List<ProxyConnector>> map = this.proxyConnectorMap;
        synchronized (map) {
            ProxyConnectorOrderComparator proxyOrderSorter = new ProxyConnectorOrderComparator();
            this.proxyConnectorMap.clear();
            List proxyConfigs = this.archivaConfiguration.getConfiguration().getProxyConnectors();
            for (ProxyConnectorConfiguration proxyConfig : proxyConfigs) {
                String key = proxyConfig.getSourceRepoId();
                try {
                    ProxyConnector connector = new ProxyConnector();
                    connector.setSourceRepository(this.repositoryFactory.getManagedRepositoryContent(proxyConfig.getSourceRepoId()));
                    connector.setTargetRepository(this.repositoryFactory.getRemoteRepositoryContent(proxyConfig.getTargetRepoId()));
                    connector.setProxyId(proxyConfig.getProxyId());
                    connector.setPolicies(proxyConfig.getPolicies());
                    connector.setOrder(proxyConfig.getOrder());
                    connector.setDisabled(proxyConfig.isDisabled());
                    ArrayList<String> blacklist = new ArrayList<String>();
                    if (CollectionUtils.isNotEmpty((Collection)proxyConfig.getBlackListPatterns())) {
                        blacklist.addAll(proxyConfig.getBlackListPatterns());
                    }
                    connector.setBlacklist(blacklist);
                    ArrayList<String> whitelist = new ArrayList<String>();
                    if (CollectionUtils.isNotEmpty((Collection)proxyConfig.getWhiteListPatterns())) {
                        whitelist.addAll(proxyConfig.getWhiteListPatterns());
                    }
                    connector.setWhitelist(whitelist);
                    List<ProxyConnector> connectors = this.proxyConnectorMap.get(key);
                    if (connectors == null) {
                        connectors = new ArrayList<ProxyConnector>();
                    }
                    connectors.add(connector);
                    Collections.sort(connectors, proxyOrderSorter);
                    this.proxyConnectorMap.put(key, connectors);
                }
                catch (RepositoryNotFoundException e) {
                    this.log.warn("Unable to use proxy connector: " + e.getMessage(), (Throwable)e);
                }
                catch (RepositoryException e) {
                    this.log.warn("Unable to use proxy connector: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        map = this.networkProxyMap;
        synchronized (map) {
            this.networkProxyMap.clear();
            List networkProxies = this.archivaConfiguration.getConfiguration().getNetworkProxies();
            for (NetworkProxyConfiguration networkProxyConfig : networkProxies) {
                String key = networkProxyConfig.getId();
                ProxyInfo proxy = new ProxyInfo();
                proxy.setType(networkProxyConfig.getProtocol());
                proxy.setHost(networkProxyConfig.getHost());
                proxy.setPort(networkProxyConfig.getPort());
                proxy.setUserName(networkProxyConfig.getUsername());
                proxy.setPassword(networkProxyConfig.getPassword());
                this.networkProxyMap.put(key, proxy);
            }
        }
    }

    @Override
    public File fetchFromProxies(ManagedRepositoryContent repository, ArtifactReference artifact) throws ProxyDownloadException {
        File localFile = this.toLocalFile(repository, artifact);
        Properties requestProperties = new Properties();
        requestProperties.setProperty("filetype", "artifact");
        requestProperties.setProperty("version", artifact.getVersion());
        requestProperties.setProperty("managedRepositoryId", repository.getId());
        List<ProxyConnector> connectors = this.getProxyConnectors(repository);
        LinkedHashMap<String, Exception> previousExceptions = new LinkedHashMap<String, Exception>();
        for (ProxyConnector connector : connectors) {
            if (connector.isDisabled()) continue;
            RemoteRepositoryContent targetRepository = connector.getTargetRepository();
            requestProperties.setProperty("remoteRepositoryId", targetRepository.getId());
            String targetPath = targetRepository.toPath(artifact);
            try {
                File downloadedFile = this.transferFile(connector, targetRepository, targetPath, repository, localFile, requestProperties, true);
                if (!this.fileExists(downloadedFile)) continue;
                this.log.debug("Successfully transferred: {}", (Object)downloadedFile.getAbsolutePath());
                return downloadedFile;
            }
            catch (NotFoundException e) {
                this.log.debug("Artifact {} not found on repository \"{}\".", (Object)Keys.toKey((ArtifactReference)artifact), (Object)targetRepository.getRepository().getId());
            }
            catch (NotModifiedException e) {
                this.log.debug("Artifact {} not updated on repository \"{}\".", (Object)Keys.toKey((ArtifactReference)artifact), (Object)targetRepository.getRepository().getId());
            }
            catch (ProxyException e) {
                this.validatePolicies(this.downloadErrorPolicies, connector.getPolicies(), requestProperties, artifact, targetRepository, localFile, e, previousExceptions);
            }
        }
        if (!previousExceptions.isEmpty()) {
            throw new ProxyDownloadException("Failures occurred downloading from some remote repositories", previousExceptions);
        }
        this.log.debug("Exhausted all target repositories, artifact {} not found.", (Object)Keys.toKey((ArtifactReference)artifact));
        return null;
    }

    @Override
    public File fetchFromProxies(ManagedRepositoryContent repository, String path) {
        File localFile = new File(repository.getRepoRoot(), path);
        if (localFile.exists()) {
            return null;
        }
        Properties requestProperties = new Properties();
        requestProperties.setProperty("filetype", "resource");
        requestProperties.setProperty("managedRepositoryId", repository.getId());
        List<ProxyConnector> connectors = this.getProxyConnectors(repository);
        for (ProxyConnector connector : connectors) {
            if (connector.isDisabled()) continue;
            RemoteRepositoryContent targetRepository = connector.getTargetRepository();
            requestProperties.setProperty("remoteRepositoryId", targetRepository.getId());
            String targetPath = path;
            try {
                File downloadedFile = this.transferFile(connector, targetRepository, targetPath, repository, localFile, requestProperties, false);
                if (!this.fileExists(downloadedFile)) continue;
                this.log.debug("Successfully transferred: {}", (Object)downloadedFile.getAbsolutePath());
                return downloadedFile;
            }
            catch (NotFoundException e) {
                this.log.debug("Resource {} not found on repository \"{}\".", (Object)path, (Object)targetRepository.getRepository().getId());
            }
            catch (NotModifiedException e) {
                this.log.debug("Resource {} not updated on repository \"{}\".", (Object)path, (Object)targetRepository.getRepository().getId());
            }
            catch (ProxyException e) {
                this.log.warn("Transfer error from repository \"" + targetRepository.getRepository().getId() + "\" for resource " + path + ", continuing to next repository. Error message: " + e.getMessage());
                this.log.debug("Full stack trace", (Throwable)e);
            }
        }
        this.log.debug("Exhausted all target repositories, resource {} not found.", (Object)path);
        return null;
    }

    @Override
    public File fetchMetatadaFromProxies(ManagedRepositoryContent repository, String logicalPath) {
        File localFile = new File(repository.getRepoRoot(), logicalPath);
        Properties requestProperties = new Properties();
        requestProperties.setProperty("filetype", "metadata");
        boolean metadataNeedsUpdating = false;
        long originalTimestamp = this.getLastModified(localFile);
        List<ProxyConnector> connectors = this.getProxyConnectors(repository);
        for (ProxyConnector connector : connectors) {
            if (connector.isDisabled()) continue;
            RemoteRepositoryContent targetRepository = connector.getTargetRepository();
            File localRepoFile = this.toLocalRepoFile(repository, targetRepository, logicalPath);
            long originalMetadataTimestamp = this.getLastModified(localRepoFile);
            try {
                this.transferFile(connector, targetRepository, logicalPath, repository, localRepoFile, requestProperties, true);
                if (!this.hasBeenUpdated(localRepoFile, originalMetadataTimestamp)) continue;
                metadataNeedsUpdating = true;
            }
            catch (NotFoundException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Metadata {} not found on remote repository \"{}\".", (Object)Lists.newArrayList((Object[])new Object[]{logicalPath, targetRepository.getRepository().getId()}), (Object)e);
            }
            catch (NotModifiedException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Metadata {} not updated on remote repository \"{}\".", (Object)Lists.newArrayList((Object[])new Object[]{logicalPath, targetRepository.getRepository().getId()}), (Object)e);
            }
            catch (ProxyException e) {
                this.log.warn("Transfer error from repository \"" + targetRepository.getRepository().getId() + "\" for versioned Metadata " + logicalPath + ", continuing to next repository. Error message: " + e.getMessage());
                this.log.debug("Full stack trace", (Throwable)e);
            }
        }
        if (this.hasBeenUpdated(localFile, originalTimestamp)) {
            metadataNeedsUpdating = true;
        }
        if (metadataNeedsUpdating || !localFile.exists()) {
            try {
                this.metadataTools.updateMetadata(repository, logicalPath);
            }
            catch (RepositoryMetadataException e) {
                this.log.warn("Unable to update metadata " + localFile.getAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.fileExists(localFile)) {
            return localFile;
        }
        return null;
    }

    private long getLastModified(File file) {
        if (!file.exists() || !file.isFile()) {
            return 0L;
        }
        return file.lastModified();
    }

    private boolean hasBeenUpdated(File file, long originalLastModified) {
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        long currentLastModified = this.getLastModified(file);
        return currentLastModified > originalLastModified;
    }

    private File toLocalRepoFile(ManagedRepositoryContent repository, RemoteRepositoryContent targetRepository, String targetPath) {
        String repoPath = this.metadataTools.getRepositorySpecificName(targetRepository, targetPath);
        return new File(repository.getRepoRoot(), repoPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasProxies(ManagedRepositoryContent repository) {
        Map<String, List<ProxyConnector>> map = this.proxyConnectorMap;
        synchronized (map) {
            return this.proxyConnectorMap.containsKey(repository.getId());
        }
    }

    private File toLocalFile(ManagedRepositoryContent repository, ArtifactReference artifact) {
        return repository.toFile(artifact);
    }

    private boolean fileExists(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        return file.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File transferFile(ProxyConnector connector, RemoteRepositoryContent remoteRepository, String remotePath, ManagedRepositoryContent repository, File resource, Properties requestProperties, boolean executeConsumers) throws ProxyException, NotModifiedException {
        block32: {
            String url = remoteRepository.getURL().getUrl();
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + remotePath;
            requestProperties.setProperty("url", url);
            if (CollectionUtils.isNotEmpty(connector.getWhitelist()) && !this.matchesPattern(remotePath, connector.getWhitelist())) {
                this.log.debug("Path [{}] is not part of defined whitelist (skipping transfer from repository [{}]).", (Object)remotePath, (Object)remoteRepository.getRepository().getName());
                return null;
            }
            if (this.matchesPattern(remotePath, connector.getBlacklist())) {
                this.log.debug("Path [{}] is part of blacklist (skipping transfer from repository [{}]).", (Object)remotePath, (Object)remoteRepository.getRepository().getName());
                return null;
            }
            try {
                this.validatePolicies(this.preDownloadPolicies, connector.getPolicies(), requestProperties, resource);
            }
            catch (PolicyViolationException e) {
                String emsg = "Transfer not attempted on " + url + " : " + e.getMessage();
                if (this.fileExists(resource)) {
                    this.log.debug("{} : using already present local file.", (Object)emsg);
                    return resource;
                }
                this.log.debug(emsg);
                return null;
            }
            File tmpMd5 = null;
            File tmpSha1 = null;
            File tmpResource = null;
            File workingDirectory = this.createWorkingDirectory(repository);
            try {
                block31: {
                    Wagon wagon = null;
                    try {
                        RepositoryURL repoUrl = remoteRepository.getURL();
                        String protocol = repoUrl.getProtocol();
                        wagon = this.wagonFactory.getWagon("wagon#" + protocol);
                        if (wagon == null) {
                            throw new ProxyException("Unsupported target repository protocol: " + protocol);
                        }
                        boolean connected = this.connectToRepository(connector, wagon, remoteRepository);
                        if (connected) {
                            tmpResource = new File(workingDirectory, resource.getName());
                            this.transferSimpleFile(wagon, remoteRepository, remotePath, repository, resource, tmpResource);
                            tmpSha1 = this.transferChecksum(wagon, remoteRepository, remotePath, repository, resource, workingDirectory, ".sha1");
                            tmpMd5 = this.transferChecksum(wagon, remoteRepository, remotePath, repository, resource, workingDirectory, ".md5");
                        }
                    }
                    catch (NotFoundException e) {
                        this.urlFailureCache.cacheFailure(url);
                        throw e;
                    }
                    catch (NotModifiedException e) {
                        throw e;
                    }
                    catch (ProxyException e) {
                        this.urlFailureCache.cacheFailure(url);
                        throw e;
                    }
                    catch (WagonFactoryException e) {
                        throw new ProxyException(e.getMessage(), e);
                    }
                    finally {
                        if (wagon != null) {
                            try {
                                wagon.disconnect();
                            }
                            catch (ConnectionException e) {
                                this.log.warn("Unable to disconnect wagon.", (Throwable)e);
                            }
                        }
                    }
                    try {
                        this.validatePolicies(this.postDownloadPolicies, connector.getPolicies(), requestProperties, tmpResource);
                    }
                    catch (PolicyViolationException e) {
                        this.log.warn("Transfer invalidated from {} : {}", (Object)url, (Object)e.getMessage());
                        executeConsumers = false;
                        if (this.fileExists(tmpResource)) break block31;
                        resource = null;
                    }
                }
                if (resource == null) break block32;
                String string = resource.getAbsolutePath().intern();
                synchronized (string) {
                    File directory = resource.getParentFile();
                    this.moveFileIfExists(tmpMd5, directory);
                    this.moveFileIfExists(tmpSha1, directory);
                    this.moveFileIfExists(tmpResource, directory);
                }
            }
            finally {
                FileUtils.deleteQuietly((File)workingDirectory);
            }
        }
        if (executeConsumers) {
            this.queueRepositoryTask(connector.getSourceRepository().getRepository().getId(), resource);
        }
        return resource;
    }

    private void queueRepositoryTask(String repositoryId, File localFile) {
        RepositoryTask task = new RepositoryTask();
        task.setRepositoryId(repositoryId);
        task.setResourceFile(localFile);
        task.setUpdateRelatedArtifacts(true);
        task.setScanAll(true);
        try {
            this.scheduler.queueTask((Task)task);
        }
        catch (TaskQueueException e) {
            this.log.error("Unable to queue repository task to execute consumers on resource file ['" + localFile.getName() + "'].");
        }
    }

    private void moveFileIfExists(File fileToMove, File directory) throws ProxyException {
        if (fileToMove != null && fileToMove.exists()) {
            File newLocation = new File(directory, fileToMove.getName());
            this.moveTempToTarget(fileToMove, newLocation);
        }
    }

    private File transferChecksum(Wagon wagon, RemoteRepositoryContent remoteRepository, String remotePath, ManagedRepositoryContent repository, File resource, File tmpDirectory, String ext) throws ProxyException {
        String url = remoteRepository.getURL().getUrl() + remotePath + ext;
        if (this.urlFailureCache.hasFailedBefore(url)) {
            return null;
        }
        File destFile = new File(tmpDirectory, resource.getName() + ext);
        try {
            this.transferSimpleFile(wagon, remoteRepository, remotePath + ext, repository, resource, destFile);
            this.log.debug("Checksum {} Downloaded: {} to move to {}", Arrays.asList(url, destFile, resource).toArray());
        }
        catch (NotFoundException e) {
            this.urlFailureCache.cacheFailure(url);
            this.log.debug("Transfer failed, checksum not found: {}", (Object)url);
        }
        catch (NotModifiedException e) {
            this.log.debug("Transfer skipped, checksum not modified: {}", (Object)url);
        }
        catch (ProxyException e) {
            this.urlFailureCache.cacheFailure(url);
            this.log.warn("Transfer failed on checksum: " + url + " : " + e.getMessage(), (Throwable)e);
            throw e;
        }
        return destFile;
    }

    private void transferSimpleFile(Wagon wagon, RemoteRepositoryContent remoteRepository, String remotePath, ManagedRepositoryContent repository, File origFile, File destFile) throws ProxyException {
        assert (remotePath != null);
        try {
            boolean success = false;
            if (!origFile.exists()) {
                this.log.debug("Retrieving {} from {}", (Object)remotePath, (Object)remoteRepository.getRepository().getName());
                wagon.get(remotePath, destFile);
                success = true;
                this.log.debug("Downloaded successfully.");
            } else {
                this.log.debug("Retrieving {} from {} if updated", (Object)remotePath, (Object)remoteRepository.getRepository().getName());
                success = wagon.getIfNewer(remotePath, destFile, origFile.lastModified());
                if (!success) {
                    throw new NotModifiedException("Not downloaded, as local file is newer than remote side: " + origFile.getAbsolutePath());
                }
                if (destFile.exists()) {
                    this.log.debug("Downloaded successfully.");
                }
            }
        }
        catch (ResourceDoesNotExistException e) {
            throw new NotFoundException("Resource [" + remoteRepository.getURL() + "/" + remotePath + "] does not exist: " + e.getMessage(), e);
        }
        catch (WagonException e) {
            String msg = "Download failure on resource [" + remoteRepository.getURL() + "/" + remotePath + "]:" + e.getMessage();
            if (e.getCause() != null) {
                msg = msg + " (cause: " + e.getCause() + ")";
            }
            throw new ProxyException(msg, e);
        }
    }

    private void validatePolicies(Map<String, ? extends DownloadPolicy> policies, Map<String, String> settings, Properties request, File localFile) throws PolicyViolationException {
        for (Map.Entry<String, ? extends DownloadPolicy> entry : policies.entrySet()) {
            String key = StringUtils.substringAfterLast((String)entry.getKey(), (String)"#");
            DownloadPolicy policy = entry.getValue();
            String defaultSetting = policy.getDefaultOption();
            String setting = StringUtils.defaultString((String)settings.get(key), (String)defaultSetting);
            this.log.debug("Applying [{}] policy with [{}]", (Object)key, (Object)setting);
            try {
                policy.applyPolicy(setting, request, localFile);
            }
            catch (PolicyConfigurationException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void validatePolicies(Map<String, DownloadErrorPolicy> policies, Map<String, String> settings, Properties request, ArtifactReference artifact, RemoteRepositoryContent content, File localFile, ProxyException exception, Map<String, Exception> previousExceptions) throws ProxyDownloadException {
        boolean process = true;
        for (Map.Entry<String, DownloadErrorPolicy> entry : policies.entrySet()) {
            String key = StringUtils.substringAfterLast((String)entry.getKey(), (String)"#");
            DownloadErrorPolicy policy = entry.getValue();
            String defaultSetting = policy.getDefaultOption();
            String setting = StringUtils.defaultString((String)settings.get(key), (String)defaultSetting);
            this.log.debug("Applying [{}] policy with [{}]", (Object)key, (Object)setting);
            try {
                process = policy.applyPolicy(setting, request, localFile, (Exception)exception, previousExceptions);
                if (process) continue;
                break;
            }
            catch (PolicyConfigurationException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (process) {
            if (!previousExceptions.containsKey(content.getId())) {
                throw new ProxyDownloadException("An error occurred in downloading from the remote repository, and the policy is to fail immediately", content.getId(), (Exception)exception);
            }
        } else {
            previousExceptions.remove(content.getId());
        }
        this.log.warn("Transfer error from repository \"" + content.getRepository().getId() + "\" for artifact " + Keys.toKey((ArtifactReference)artifact) + ", continuing to next repository. Error message: " + exception.getMessage());
        this.log.debug("Full stack trace", (Throwable)exception);
    }

    private File createWorkingDirectory(ManagedRepositoryContent repository) {
        try {
            File tmpDir = File.createTempFile(".workingdirectory", null, new File(repository.getRepoRoot()));
            tmpDir.delete();
            tmpDir.mkdirs();
            return tmpDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create working directory for this request", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTempToTarget(File temp, File target) throws ProxyException {
        block8: {
            if (target.exists() && !target.delete()) {
                throw new ProxyException("Unable to overwrite existing target file: " + target.getAbsolutePath());
            }
            target.getParentFile().mkdirs();
            if (!temp.renameTo(target)) {
                this.log.warn("Unable to rename tmp file to its final name... resorting to copy command.");
                try {
                    FileUtils.copyFile((File)temp, (File)target);
                }
                catch (IOException e) {
                    if (target.exists()) {
                        this.log.debug("Tried to copy file {} to {} but file with this name already exists.", (Object)temp.getName(), (Object)target.getAbsolutePath());
                        break block8;
                    }
                    throw new ProxyException("Cannot copy tmp file " + temp.getAbsolutePath() + " to its final location", e);
                }
                finally {
                    FileUtils.deleteQuietly((File)temp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectToRepository(ProxyConnector connector, Wagon wagon, RemoteRepositoryContent remoteRepository) {
        ProxyInfo networkProxy;
        boolean connected = false;
        Map<String, ProxyInfo> map = this.networkProxyMap;
        synchronized (map) {
            networkProxy = this.networkProxyMap.get(connector.getProxyId());
        }
        if (this.log.isDebugEnabled() && networkProxy != null) {
            String msg = "Using network proxy " + networkProxy.getHost() + ":" + networkProxy.getPort() + " to connect to remote repository " + remoteRepository.getURL();
            if (networkProxy.getNonProxyHosts() != null) {
                msg = msg + "; excluding hosts: " + networkProxy.getNonProxyHosts();
            }
            if (StringUtils.isNotBlank((String)networkProxy.getUserName())) {
                msg = msg + "; as user: " + networkProxy.getUserName();
            }
            this.log.debug(msg);
        }
        AuthenticationInfo authInfo = null;
        String username = remoteRepository.getRepository().getUserName();
        String password = remoteRepository.getRepository().getPassword();
        if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
            this.log.debug("Using username {} to connect to remote repository {}", (Object)username, (Object)remoteRepository.getURL());
            authInfo = new AuthenticationInfo();
            authInfo.setUserName(username);
            authInfo.setPassword(password);
        }
        int timeoutInMilliseconds = remoteRepository.getRepository().getTimeout() * 1000;
        wagon.setTimeout(timeoutInMilliseconds);
        try {
            Repository wagonRepository = new Repository(remoteRepository.getId(), remoteRepository.getURL().toString());
            wagon.connect(wagonRepository, authInfo, networkProxy);
            connected = true;
        }
        catch (ConnectionException e) {
            this.log.warn("Could not connect to " + remoteRepository.getRepository().getName() + ": " + e.getMessage());
            connected = false;
        }
        catch (AuthenticationException e) {
            this.log.warn("Could not connect to " + remoteRepository.getRepository().getName() + ": " + e.getMessage());
            connected = false;
        }
        return connected;
    }

    private boolean matchesPattern(String path, List<String> patterns) {
        if (CollectionUtils.isEmpty(patterns)) {
            return false;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        for (String pattern : patterns) {
            if (!pattern.startsWith("/")) {
                pattern = "/" + pattern;
            }
            if (!SelectorUtils.matchPath((String)pattern, (String)path, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProxyConnector> getProxyConnectors(ManagedRepositoryContent repository) {
        Map<String, List<ProxyConnector>> map = this.proxyConnectorMap;
        synchronized (map) {
            List<ProxyConnector> ret = this.proxyConnectorMap.get(repository.getId());
            if (ret == null) {
                return Collections.emptyList();
            }
            Collections.sort(ret, ProxyConnectorOrderComparator.getInstance());
            return ret;
        }
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isNetworkProxy((String)propertyName) || ConfigurationNames.isManagedRepositories((String)propertyName) || ConfigurationNames.isRemoteRepositories((String)propertyName) || ConfigurationNames.isProxyConnector((String)propertyName)) {
            this.initConnectorsAndNetworkProxies();
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    public ArchivaConfiguration getArchivaConfiguration() {
        return this.archivaConfiguration;
    }

    public void setArchivaConfiguration(ArchivaConfiguration archivaConfiguration) {
        this.archivaConfiguration = archivaConfiguration;
    }

    public RepositoryContentFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public void setRepositoryFactory(RepositoryContentFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public MetadataTools getMetadataTools() {
        return this.metadataTools;
    }

    public void setMetadataTools(MetadataTools metadataTools) {
        this.metadataTools = metadataTools;
    }

    public UrlFailureCache getUrlFailureCache() {
        return this.urlFailureCache;
    }

    public void setUrlFailureCache(UrlFailureCache urlFailureCache) {
        this.urlFailureCache = urlFailureCache;
    }

    public WagonFactory getWagonFactory() {
        return this.wagonFactory;
    }

    public void setWagonFactory(WagonFactory wagonFactory) {
        this.wagonFactory = wagonFactory;
    }

    public Map<String, PreDownloadPolicy> getPreDownloadPolicies() {
        return this.preDownloadPolicies;
    }

    public void setPreDownloadPolicies(Map<String, PreDownloadPolicy> preDownloadPolicies) {
        this.preDownloadPolicies = preDownloadPolicies;
    }

    public Map<String, PostDownloadPolicy> getPostDownloadPolicies() {
        return this.postDownloadPolicies;
    }

    public void setPostDownloadPolicies(Map<String, PostDownloadPolicy> postDownloadPolicies) {
        this.postDownloadPolicies = postDownloadPolicies;
    }

    public Map<String, DownloadErrorPolicy> getDownloadErrorPolicies() {
        return this.downloadErrorPolicies;
    }

    public void setDownloadErrorPolicies(Map<String, DownloadErrorPolicy> downloadErrorPolicies) {
        this.downloadErrorPolicies = downloadErrorPolicies;
    }
}

