/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.proxy.common;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.archiva.proxy.common.DebugTransferListener;
import org.apache.archiva.proxy.common.WagonFactory;
import org.apache.archiva.proxy.common.WagonFactoryException;
import org.apache.archiva.proxy.common.WagonFactoryRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="wagonFactory")
public class DefaultWagonFactory
implements WagonFactory {
    private ApplicationContext applicationContext;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private DebugTransferListener debugTransferListener = new DebugTransferListener();

    @Inject
    public DefaultWagonFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public Wagon getWagon(WagonFactoryRequest wagonFactoryRequest) throws WagonFactoryException {
        try {
            String protocol;
            String string = protocol = StringUtils.startsWith((String)wagonFactoryRequest.getProtocol(), (String)"wagon#") ? wagonFactoryRequest.getProtocol() : "wagon#" + wagonFactoryRequest.getProtocol();
            if (wagonFactoryRequest.getNetworkProxy() != null && wagonFactoryRequest.getNetworkProxy().isUseNtlm()) {
                protocol = protocol + "-ntlm";
            }
            Wagon wagon = (Wagon)this.applicationContext.getBean(protocol, Wagon.class);
            wagon.addTransferListener((TransferListener)this.debugTransferListener);
            this.configureUserAgent(wagon, wagonFactoryRequest);
            return wagon;
        }
        catch (BeansException e) {
            throw new WagonFactoryException(e.getMessage(), e);
        }
    }

    protected void configureUserAgent(Wagon wagon, WagonFactoryRequest wagonFactoryRequest) {
        try {
            Class<?> clazz = wagon.getClass();
            Method getHttpHeaders = clazz.getMethod("getHttpHeaders", null);
            Properties headers = (Properties)getHttpHeaders.invoke((Object)wagon, null);
            if (headers == null) {
                headers = new Properties();
            }
            headers.put("User-Agent", wagonFactoryRequest.getUserAgent());
            if (!wagonFactoryRequest.getHeaders().isEmpty()) {
                for (Map.Entry<String, String> entry : wagonFactoryRequest.getHeaders().entrySet()) {
                    headers.put(entry.getKey(), entry.getValue());
                }
            }
            Method setHttpHeaders = clazz.getMethod("setHttpHeaders", Properties.class);
            setHttpHeaders.invoke((Object)wagon, headers);
            this.logger.debug("http headers set to: {}", (Object)headers);
        }
        catch (Exception e) {
            this.logger.warn("fail to configure User-Agent: " + e.getMessage(), (Throwable)e);
        }
    }
}

