/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.proxy.common;

import javax.inject.Inject;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.proxy.common.DebugTransferListener;
import org.apache.archiva.proxy.common.WagonFactory;
import org.apache.archiva.proxy.common.WagonFactoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferListener;
import org.springframework.stereotype.Service;

@Service(value="wagonFactory")
public class DefaultWagonFactory
implements WagonFactory {
    private PlexusSisuBridge plexusSisuBridge;
    private DebugTransferListener debugTransferListener = new DebugTransferListener();

    @Inject
    public DefaultWagonFactory(PlexusSisuBridge plexusSisuBridge) {
        this.plexusSisuBridge = plexusSisuBridge;
    }

    public Wagon getWagon(String protocol) throws WagonFactoryException {
        try {
            protocol = StringUtils.remove((String)protocol, (String)"wagon#");
            Wagon wagon = (Wagon)this.plexusSisuBridge.lookup(Wagon.class, protocol);
            wagon.addTransferListener((TransferListener)this.debugTransferListener);
            return wagon;
        }
        catch (PlexusSisuBridgeException e) {
            throw new WagonFactoryException(e.getMessage(), e);
        }
    }
}

