/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.policies;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.archiva.policies.DownloadErrorPolicy;
import org.apache.archiva.policies.PolicyConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="downloadErrorPolicy#propagate-errors")
public class PropagateErrorsDownloadPolicy
implements DownloadErrorPolicy {
    private Logger log = LoggerFactory.getLogger(PropagateErrorsDownloadPolicy.class);
    public static final String STOP = "stop";
    public static final String QUEUE = "queue error";
    public static final String IGNORE = "ignore";
    private List<String> options = new ArrayList<String>(3);

    public PropagateErrorsDownloadPolicy() {
        this.options.add(STOP);
        this.options.add(QUEUE);
        this.options.add(IGNORE);
    }

    @Override
    public boolean applyPolicy(String policySetting, Properties request, File localFile, Exception exception, Map<String, Exception> previousExceptions) throws PolicyConfigurationException {
        if (!this.options.contains(policySetting)) {
            throw new PolicyConfigurationException("Unknown error policy setting [" + policySetting + "], valid settings are [" + StringUtils.join(this.options.iterator(), (String)",") + "]");
        }
        if (IGNORE.equals(policySetting)) {
            this.log.debug("Error policy set to IGNORE.");
            return false;
        }
        String repositoryId = request.getProperty("remoteRepositoryId");
        if (STOP.equals(policySetting)) {
            return true;
        }
        if (QUEUE.equals(policySetting)) {
            previousExceptions.put(repositoryId, exception);
            return true;
        }
        throw new PolicyConfigurationException("Unable to process checksum policy of [" + policySetting + "], please file a bug report.");
    }

    @Override
    public String getDefaultOption() {
        return QUEUE;
    }

    @Override
    public String getId() {
        return "propagate-errors";
    }

    @Override
    public String getName() {
        return "On remote error";
    }

    @Override
    public List<String> getOptions() {
        return this.options;
    }
}

