/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.policies;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.archiva.checksum.ChecksumAlgorithm;
import org.apache.archiva.checksum.ChecksummedFile;
import org.apache.archiva.policies.PolicyConfigurationException;
import org.apache.archiva.policies.PolicyViolationException;
import org.apache.archiva.policies.PostDownloadPolicy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="postDownloadPolicy#checksum")
public class ChecksumPolicy
implements PostDownloadPolicy {
    private Logger log = LoggerFactory.getLogger(ChecksumPolicy.class);
    public static final String IGNORE = "ignore";
    public static final String FAIL = "fail";
    public static final String FIX = "fix";
    private ChecksumAlgorithm[] algorithms = new ChecksumAlgorithm[]{ChecksumAlgorithm.SHA1, ChecksumAlgorithm.MD5};
    private List<String> options = new ArrayList<String>();

    public ChecksumPolicy() {
        this.options.add(FAIL);
        this.options.add(FIX);
        this.options.add(IGNORE);
    }

    @Override
    public void applyPolicy(String policySetting, Properties request, File localFile) throws PolicyViolationException, PolicyConfigurationException {
        if ("resource".equals(request.getProperty("filetype"))) {
            return;
        }
        if (!this.options.contains(policySetting)) {
            throw new PolicyConfigurationException("Unknown checksum policy setting [" + policySetting + "], valid settings are [" + StringUtils.join(this.options.iterator(), (String)",") + "]");
        }
        if (IGNORE.equals(policySetting)) {
            this.log.debug("Checksum policy set to IGNORE.");
            return;
        }
        if (!localFile.exists()) {
            throw new PolicyViolationException("Checksum policy failure, local file " + localFile.getAbsolutePath() + " does not exist to check.");
        }
        if (FAIL.equals(policySetting)) {
            ChecksummedFile checksum = new ChecksummedFile(localFile);
            if (checksum.isValidChecksums(this.algorithms)) {
                return;
            }
            for (ChecksumAlgorithm algorithm : this.algorithms) {
                File file = new File(localFile.getAbsolutePath() + "." + algorithm.getExt());
                if (!file.exists()) continue;
                file.delete();
            }
            localFile.delete();
            throw new PolicyViolationException("Checksums do not match, policy set to FAIL, deleting checksum files and local file " + localFile.getAbsolutePath() + ".");
        }
        if (FIX.equals(policySetting)) {
            ChecksummedFile checksum = new ChecksummedFile(localFile);
            if (checksum.fixChecksums(this.algorithms)) {
                this.log.debug("Checksum policy set to FIX, checksum files have been updated.");
                return;
            }
            throw new PolicyViolationException("Checksum policy set to FIX, yet unable to update checksums for local file " + localFile.getAbsolutePath() + ".");
        }
        throw new PolicyConfigurationException("Unable to process checksum policy of [" + policySetting + "], please file a bug report.");
    }

    @Override
    public String getDefaultOption() {
        return FIX;
    }

    @Override
    public String getId() {
        return "checksum";
    }

    @Override
    public String getName() {
        return "Checksum";
    }

    @Override
    public List<String> getOptions() {
        return this.options;
    }
}

