/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.common.plexusbridge;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="plexusSisuBridge")
public class PlexusSisuBridge {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean containerAutoWiring = true;
    private String containerClassPathScanning = "index";
    private String containerComponentVisibility = "realm";
    private URL overridingComponentsXml;
    private ClassRealm containerRealm;
    private DefaultPlexusContainer plexusContainer;

    @PostConstruct
    public void initialize() throws PlexusSisuBridgeException {
        DefaultContainerConfiguration conf = new DefaultContainerConfiguration();
        conf.setAutoWiring(this.containerAutoWiring);
        conf.setClassPathScanning(this.containerClassPathScanning);
        conf.setComponentVisibility(this.containerComponentVisibility);
        conf.setContainerConfigurationURL(this.overridingComponentsXml);
        ClassWorld classWorld = new ClassWorld();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        this.containerRealm = new ClassRealm(classWorld, "maven", tccl);
        if (tccl instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ((URLClassLoader)tccl).getURLs()) {
                this.containerRealm.addURL(url);
            }
        }
        conf.setRealm(this.containerRealm);
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.containerRealm);
            this.plexusContainer = new DefaultPlexusContainer((ContainerConfiguration)conf);
        }
        catch (PlexusContainerException e) {
            throw new PlexusSisuBridgeException(e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ori);
        }
    }

    private URL[] getClassLoaderURLs(ClassLoader classLoader) {
        try {
            Method method = classLoader.getClass().getMethod("getURLs", new Class[0]);
            if (method != null) {
                return (URL[])method.invoke((Object)classLoader, null);
            }
        }
        catch (Exception e) {
            this.log.info("ignore issue trying to find url[] from classloader {}", (Object)e.getMessage());
        }
        return new URL[0];
    }

    public <T> T lookup(Class<T> clazz) throws PlexusSisuBridgeException {
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.containerRealm);
            Object object = this.plexusContainer.lookup(clazz);
            return (T)object;
        }
        catch (ComponentLookupException e) {
            throw new PlexusSisuBridgeException(e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ori);
        }
    }

    public <T> T lookup(Class<T> clazz, String hint) throws PlexusSisuBridgeException {
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.containerRealm);
            Object object = this.plexusContainer.lookup(clazz, hint);
            return (T)object;
        }
        catch (ComponentLookupException e) {
            throw new PlexusSisuBridgeException(e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ori);
        }
    }

    public <T> List<T> lookupList(Class<T> clazz) throws PlexusSisuBridgeException {
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.containerRealm);
            List list = this.plexusContainer.lookupList(clazz);
            return list;
        }
        catch (ComponentLookupException e) {
            throw new PlexusSisuBridgeException(e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ori);
        }
    }

    public <T> Map<String, T> lookupMap(Class<T> clazz) throws PlexusSisuBridgeException {
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.containerRealm);
            Map map = this.plexusContainer.lookupMap(clazz);
            return map;
        }
        catch (ComponentLookupException e) {
            throw new PlexusSisuBridgeException(e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ori);
        }
    }
}

