/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.common.plexusbridge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.maven.index.context.IndexCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="mavenIndexerUtils")
public class MavenIndexerUtils {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private List<? extends IndexCreator> allIndexCreators;

    @Inject
    public MavenIndexerUtils(PlexusSisuBridge plexusSisuBridge) throws PlexusSisuBridgeException {
        this.allIndexCreators = new ArrayList<IndexCreator>(plexusSisuBridge.lookupList(IndexCreator.class));
        if (this.allIndexCreators == null || this.allIndexCreators.isEmpty()) {
            this.log.warn("using lookupList from sisu plexus failed so build indexCreator manually");
            this.allIndexCreators = Arrays.asList(plexusSisuBridge.lookup(IndexCreator.class, "osgi-metadatas"), plexusSisuBridge.lookup(IndexCreator.class, "maven-archetype"), plexusSisuBridge.lookup(IndexCreator.class, "min"), plexusSisuBridge.lookup(IndexCreator.class, "jarContent"), plexusSisuBridge.lookup(IndexCreator.class, "maven-plugin"));
        }
        if (this.allIndexCreators == null || this.allIndexCreators.isEmpty()) {
            throw new PlexusSisuBridgeException("no way to initiliaze IndexCreator");
        }
        this.log.debug("allIndexCreators {}", this.allIndexCreators);
    }

    public List<? extends IndexCreator> getAllIndexCreators() {
        return this.allIndexCreators;
    }

    public void setAllIndexCreators(List<IndexCreator> allIndexCreators) {
        this.allIndexCreators = allIndexCreators;
    }
}

