/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.common.plexusbridge;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.Md5Digester;
import org.codehaus.plexus.digest.Sha1Digester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="digesterUtils")
public class DigesterUtils {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private List<? extends Digester> allDigesters;

    @Inject
    public DigesterUtils(PlexusSisuBridge plexusSisuBridge) throws PlexusSisuBridgeException {
        this.allDigesters = plexusSisuBridge.lookupList(Digester.class);
        if (this.allDigesters == null || this.allDigesters.isEmpty()) {
            this.log.warn("using lookupList from sisu plexus failed so build plexus Digesters manually");
            this.allDigesters = Arrays.asList(new Sha1Digester(), new Md5Digester());
        }
        if (this.allDigesters == null || this.allDigesters.isEmpty()) {
            throw new PlexusSisuBridgeException("no way to initiliaze IndexCreator");
        }
        this.log.debug("allIndexCreators {}", this.allDigesters);
    }

    public List<? extends Digester> getAllDigesters() {
        return this.allDigesters;
    }

    public void setAllDigesters(List<? extends Digester> allDigesters) {
        this.allDigesters = allDigesters;
    }
}

