/*
 * $Id$
 */

package org.apache.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class ArchivaRepositoryMetadata.
 * 
 * @version $Revision$ $Date$
 */
public class ArchivaRepositoryMetadata
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The Group ID of the metadata.
     *           
     */
    private String groupId;

    /**
     * 
     *             The Artifact ID of the metadata.
     *           
     */
    private String artifactId;

    /**
     * 
     *             The Version of the metadata.
     *           
     */
    private String version;

    /**
     * 
     *             The latest version id.
     *           
     */
    private String latestVersion;

    /**
     * 
     *             The released version id.
     *           
     */
    private String releasedVersion;

    /**
     * 
     *             The snapshot version id.
     *           
     */
    private SnapshotVersion snapshotVersion;

    /**
     * Field plugins.
     */
    private java.util.List<Plugin> plugins;

    /**
     * Field availableVersions.
     */
    private java.util.List<String> availableVersions;

    /**
     * 
     *             When the metadata was last updated.
     *           
     */
    private String lastUpdated;

    /**
     * 
     *             The Last Modified Timestamp of this file.
     *           
     */
    private java.util.Date fileLastModified;

    /**
     * 
     *             The size of the artifact on disk.
     *           
     */
    private long fileSize = 0L;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addAvailableVersion.
     * 
     * @param string
     */
    public void addAvailableVersion( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ArchivaRepositoryMetadata.addAvailableVersions(string) parameter must be instanceof " + String.class.getName() );
        }
        getAvailableVersions().add( string );
    } //-- void addAvailableVersion( String )

    /**
     * Method addPlugin.
     * 
     * @param plugin
     */
    public void addPlugin( Plugin plugin )
    {
        if ( !(plugin instanceof Plugin) )
        {
            throw new ClassCastException( "ArchivaRepositoryMetadata.addPlugins(plugin) parameter must be instanceof " + Plugin.class.getName() );
        }
        getPlugins().add( plugin );
    } //-- void addPlugin( Plugin )

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof ArchivaRepositoryMetadata ) )
        {
            return false;
        }

        ArchivaRepositoryMetadata that = (ArchivaRepositoryMetadata) other;
        boolean result = true;

        result = result && ( getGroupId() == null ? that.getGroupId() == null : getGroupId().equals( that.getGroupId() ) );
        result = result && ( getArtifactId() == null ? that.getArtifactId() == null : getArtifactId().equals( that.getArtifactId() ) );
        result = result && ( getVersion() == null ? that.getVersion() == null : getVersion().equals( that.getVersion() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get 
     *             The Artifact ID of the metadata.
     *           
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId()

    /**
     * Method getAvailableVersions.
     * 
     * @return List
     */
    public java.util.List<String> getAvailableVersions()
    {
        if ( this.availableVersions == null )
        {
            this.availableVersions = new java.util.ArrayList<String>();
        }

        return this.availableVersions;
    } //-- java.util.List<String> getAvailableVersions()

    /**
     * Get 
     *             The Last Modified Timestamp of this file.
     *           
     * 
     * @return Date
     */
    public java.util.Date getFileLastModified()
    {
        return this.fileLastModified;
    } //-- java.util.Date getFileLastModified()

    /**
     * Get 
     *             The size of the artifact on disk.
     *           
     * 
     * @return long
     */
    public long getFileSize()
    {
        return this.fileSize;
    } //-- long getFileSize()

    /**
     * Get 
     *             The Group ID of the metadata.
     *           
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId()

    /**
     * Get 
     *             When the metadata was last updated.
     *           
     * 
     * @return String
     */
    public String getLastUpdated()
    {
        return this.lastUpdated;
    } //-- String getLastUpdated()

    /**
     * Get 
     *             The latest version id.
     *           
     * 
     * @return String
     */
    public String getLatestVersion()
    {
        return this.latestVersion;
    } //-- String getLatestVersion()

    /**
     * Method getPlugins.
     * 
     * @return List
     */
    public java.util.List<Plugin> getPlugins()
    {
        if ( this.plugins == null )
        {
            this.plugins = new java.util.ArrayList<Plugin>();
        }

        return this.plugins;
    } //-- java.util.List<Plugin> getPlugins()

    /**
     * Get 
     *             The released version id.
     *           
     * 
     * @return String
     */
    public String getReleasedVersion()
    {
        return this.releasedVersion;
    } //-- String getReleasedVersion()

    /**
     * Get 
     *             The snapshot version id.
     *           
     * 
     * @return SnapshotVersion
     */
    public SnapshotVersion getSnapshotVersion()
    {
        return this.snapshotVersion;
    } //-- SnapshotVersion getSnapshotVersion()

    /**
     * Get 
     *             The Version of the metadata.
     *           
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( groupId != null ? groupId.hashCode() : 0 );
        result = 37 * result + ( artifactId != null ? artifactId.hashCode() : 0 );
        result = 37 * result + ( version != null ? version.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Method removeAvailableVersion.
     * 
     * @param string
     */
    public void removeAvailableVersion( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ArchivaRepositoryMetadata.removeAvailableVersions(string) parameter must be instanceof " + String.class.getName() );
        }
        getAvailableVersions().remove( string );
    } //-- void removeAvailableVersion( String )

    /**
     * Method removePlugin.
     * 
     * @param plugin
     */
    public void removePlugin( Plugin plugin )
    {
        if ( !(plugin instanceof Plugin) )
        {
            throw new ClassCastException( "ArchivaRepositoryMetadata.removePlugins(plugin) parameter must be instanceof " + Plugin.class.getName() );
        }
        getPlugins().remove( plugin );
    } //-- void removePlugin( Plugin )

    /**
     * Set 
     *             The Artifact ID of the metadata.
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId( String )

    /**
     * Set 
     *             The list of available version ids.
     *           
     * 
     * @param availableVersions
     */
    public void setAvailableVersions( java.util.List<String> availableVersions )
    {
        this.availableVersions = availableVersions;
    } //-- void setAvailableVersions( java.util.List )

    /**
     * Set 
     *             The Last Modified Timestamp of this file.
     *           
     * 
     * @param fileLastModified
     */
    public void setFileLastModified( java.util.Date fileLastModified )
    {
        this.fileLastModified = fileLastModified;
    } //-- void setFileLastModified( java.util.Date )

    /**
     * Set 
     *             The size of the artifact on disk.
     *           
     * 
     * @param fileSize
     */
    public void setFileSize( long fileSize )
    {
        this.fileSize = fileSize;
    } //-- void setFileSize( long )

    /**
     * Set 
     *             The Group ID of the metadata.
     *           
     * 
     * @param groupId
     */
    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    } //-- void setGroupId( String )

    /**
     * Set 
     *             When the metadata was last updated.
     *           
     * 
     * @param lastUpdated
     */
    public void setLastUpdated( String lastUpdated )
    {
        this.lastUpdated = lastUpdated;
    } //-- void setLastUpdated( String )

    /**
     * Set 
     *             The latest version id.
     *           
     * 
     * @param latestVersion
     */
    public void setLatestVersion( String latestVersion )
    {
        this.latestVersion = latestVersion;
    } //-- void setLatestVersion( String )

    /**
     * Set 
     *             The available plugins.
     *           
     * 
     * @param plugins
     */
    public void setPlugins( java.util.List<Plugin> plugins )
    {
        this.plugins = plugins;
    } //-- void setPlugins( java.util.List )

    /**
     * Set 
     *             The released version id.
     *           
     * 
     * @param releasedVersion
     */
    public void setReleasedVersion( String releasedVersion )
    {
        this.releasedVersion = releasedVersion;
    } //-- void setReleasedVersion( String )

    /**
     * Set 
     *             The snapshot version id.
     *           
     * 
     * @param snapshotVersion
     */
    public void setSnapshotVersion( SnapshotVersion snapshotVersion )
    {
        this.snapshotVersion = snapshotVersion;
    } //-- void setSnapshotVersion( SnapshotVersion )

    /**
     * Set 
     *             The Version of the metadata.
     *           
     * 
     * @param version
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "groupId = '" );
        buf.append( getGroupId() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "artifactId = '" );
        buf.append( getArtifactId() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "version = '" );
        buf.append( getVersion() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


    private static final long serialVersionUID = 914715358219606100L;
          
    public void updateTimestamp()
    {
        setLastUpdatedTimestamp( new java.util.Date() );
    }

    public void setLastUpdatedTimestamp( java.util.Date date )
    {
        java.util.TimeZone timezone = java.util.TimeZone.getTimeZone( "UTC" );
        java.text.DateFormat fmt = new java.text.SimpleDateFormat( "yyyyMMddHHmmss" );
        fmt.setTimeZone( timezone );
        setLastUpdated( fmt.format( date ) );
    }
          
}
