/*
 * $Id$
 */

package org.apache.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class ArtifactReference.
 * 
 * @version $Revision$ $Date$
 */
public class ArtifactReference
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The Group ID of the repository content.
     *           
     */
    private String groupId;

    /**
     * 
     *             The Artifact ID of the repository content.
     *           
     */
    private String artifactId;

    /**
     * 
     *             The version of the repository content.
     *           
     */
    private String version;

    /**
     * 
     *             The classifier for this artifact.
     *           
     */
    private String classifier;

    /**
     * 
     *             The type of artifact.
     *           
     */
    private String type;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The Artifact ID of the repository content.
     *           
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId()

    /**
     * Get 
     *             The classifier for this artifact.
     *           
     * 
     * @return String
     */
    public String getClassifier()
    {
        return this.classifier;
    } //-- String getClassifier()

    /**
     * Get 
     *             The Group ID of the repository content.
     *           
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId()

    /**
     * Get 
     *             The type of artifact.
     *           
     * 
     * @return String
     */
    public String getType()
    {
        return this.type;
    } //-- String getType()

    /**
     * Get 
     *             The version of the repository content.
     *           
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion()

    /**
     * Set 
     *             The Artifact ID of the repository content.
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId( String )

    /**
     * Set 
     *             The classifier for this artifact.
     *           
     * 
     * @param classifier
     */
    public void setClassifier( String classifier )
    {
        this.classifier = classifier;
    } //-- void setClassifier( String )

    /**
     * Set 
     *             The Group ID of the repository content.
     *           
     * 
     * @param groupId
     */
    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    } //-- void setGroupId( String )

    /**
     * Set 
     *             The type of artifact.
     *           
     * 
     * @param type
     */
    public void setType( String type )
    {
        this.type = type;
    } //-- void setType( String )

    /**
     * Set 
     *             The version of the repository content.
     *           
     * 
     * @param version
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String )


    private static final long serialVersionUID = -6116764846682178732L;
          
    private static String defaultString( String value )
    {
        if ( value == null )
        {
            return "";
        }
        
        return value.trim();
    }
          
    public static String toKey( ArtifactReference artifactReference )
    {
        StringBuffer key = new StringBuffer();

        key.append( defaultString( artifactReference.getGroupId() ) ).append( ":" );
        key.append( defaultString( artifactReference.getArtifactId() ) ).append( ":" );
        key.append( defaultString( artifactReference.getVersion() ) ).append( ":" );
        key.append( defaultString( artifactReference.getClassifier() ) ).append( ":" );
        key.append( defaultString( artifactReference.getType() ) );

        return key.toString();
    }

    public static String toVersionlessKey( ArtifactReference artifactReference )
    {
        StringBuffer key = new StringBuffer();

        key.append( defaultString( artifactReference.getGroupId() ) ).append( ":" );
        key.append( defaultString( artifactReference.getArtifactId() ) ).append( ":" );
        key.append( defaultString( artifactReference.getClassifier() ) ).append( ":" );
        key.append( defaultString( artifactReference.getType() ) );

        return key.toString();
    }
          
    public int hashCode()
    {
        final int PRIME = 31;
        int result = 1;
        result = PRIME * result + ( ( groupId == null ) ? 0 : groupId.hashCode() );
        result = PRIME * result + ( ( artifactId == null ) ? 0 : artifactId.hashCode() );
        result = PRIME * result + ( ( version == null ) ? 0 : version.hashCode() );
        result = PRIME * result + ( ( classifier == null ) ? 0 : classifier.hashCode() );
        result = PRIME * result + ( ( type == null ) ? 0 : type.hashCode() );
        return result;
    }

    public boolean equals( Object obj )
    {
        if ( this == obj )
        {
            return true;
        }
        
        if ( obj == null )
        {
            return false;
        }
        
        if ( getClass() != obj.getClass() )
        {
            return false;
        }

        final ArtifactReference other = (ArtifactReference) obj;

        if ( groupId == null )
        {
            if ( other.groupId != null )
            {
                return false;
            }
        }
        else if ( !groupId.equals( other.groupId ) )
        {
            return false;
        }

        if ( artifactId == null )
        {
            if ( other.artifactId != null )
            {
                return false;
            }
        }
        else if ( !artifactId.equals( other.artifactId ) )
        {
            return false;
        }

        if ( version == null )
        {
            if ( other.version != null )
            {
                return false;
            }
        }
        else if ( !version.equals( other.version ) )
        {
            return false;
        }

        if ( classifier == null )
        {
            if ( other.classifier != null )
            {
                return false;
            }
        }
        else if ( !classifier.equals( other.classifier ) )
        {
            return false;
        }
        
        if ( type == null )
        {
            if ( other.type != null )
            {
                return false;
            }
        }
        else if ( !type.equals( other.type ) )
        {
            return false;
        }
        
        return true;
    }          
          
}
