/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A Mailing List.
 * 
 * @version $Revision$ $Date$
 */
public class MailingList
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The name of the mailing list.
     */
    private String name;

    /**
     * The email address to subscribe to this mailing list.
     */
    private String subscribeAddress;

    /**
     * The email address to unsubscribe to this mailing list.
     */
    private String unsubscribeAddress;

    /**
     * The email address to post to this mailing list.
     */
    private String postAddress;

    /**
     * The url to the archive for this mailing list.
     */
    private String mainArchiveUrl;

    /**
     * Field otherArchives.
     */
    private java.util.List<String> otherArchives;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addOtherArchive.
     * 
     * @param string
     */
    public void addOtherArchive( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "MailingList.addOtherArchives(string) parameter must be instanceof " + String.class.getName() );
        }
        getOtherArchives().add( string );
    } //-- void addOtherArchive( String )

    /**
     * Get the url to the archive for this mailing list.
     * 
     * @return String
     */
    public String getMainArchiveUrl()
    {
        return this.mainArchiveUrl;
    } //-- String getMainArchiveUrl()

    /**
     * Get the name of the mailing list.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Method getOtherArchives.
     * 
     * @return List
     */
    public java.util.List<String> getOtherArchives()
    {
        if ( this.otherArchives == null )
        {
            this.otherArchives = new java.util.ArrayList<String>();
        }

        return this.otherArchives;
    } //-- java.util.List<String> getOtherArchives()

    /**
     * Get the email address to post to this mailing list.
     * 
     * @return String
     */
    public String getPostAddress()
    {
        return this.postAddress;
    } //-- String getPostAddress()

    /**
     * Get the email address to subscribe to this mailing list.
     * 
     * @return String
     */
    public String getSubscribeAddress()
    {
        return this.subscribeAddress;
    } //-- String getSubscribeAddress()

    /**
     * Get the email address to unsubscribe to this mailing list.
     * 
     * @return String
     */
    public String getUnsubscribeAddress()
    {
        return this.unsubscribeAddress;
    } //-- String getUnsubscribeAddress()

    /**
     * Method removeOtherArchive.
     * 
     * @param string
     */
    public void removeOtherArchive( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "MailingList.removeOtherArchives(string) parameter must be instanceof " + String.class.getName() );
        }
        getOtherArchives().remove( string );
    } //-- void removeOtherArchive( String )

    /**
     * Set the url to the archive for this mailing list.
     * 
     * @param mainArchiveUrl
     */
    public void setMainArchiveUrl( String mainArchiveUrl )
    {
        this.mainArchiveUrl = mainArchiveUrl;
    } //-- void setMainArchiveUrl( String )

    /**
     * Set the name of the mailing list.
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Set the email address to subscribe to this mailing list.
     * 
     * @param otherArchives
     */
    public void setOtherArchives( java.util.List<String> otherArchives )
    {
        this.otherArchives = otherArchives;
    } //-- void setOtherArchives( java.util.List )

    /**
     * Set the email address to post to this mailing list.
     * 
     * @param postAddress
     */
    public void setPostAddress( String postAddress )
    {
        this.postAddress = postAddress;
    } //-- void setPostAddress( String )

    /**
     * Set the email address to subscribe to this mailing list.
     * 
     * @param subscribeAddress
     */
    public void setSubscribeAddress( String subscribeAddress )
    {
        this.subscribeAddress = subscribeAddress;
    } //-- void setSubscribeAddress( String )

    /**
     * Set the email address to unsubscribe to this mailing list.
     * 
     * @param unsubscribeAddress
     */
    public void setUnsubscribeAddress( String unsubscribeAddress )
    {
        this.unsubscribeAddress = unsubscribeAddress;
    } //-- void setUnsubscribeAddress( String )


    private static final long serialVersionUID = 843006855864469245L;
          
}
