/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class ArchivaAuditLogs.
 * 
 * @version $Revision$ $Date$
 */
public class ArchivaAuditLogs
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The repository id where the operation was done.
     *           
     */
    private String repositoryId;

    /**
     * 
     *             The timestamp on when the event happened.
     *           
     */
    private java.util.Date eventDate;

    /**
     * 
     *             The affected artifact, if there is one.
     *           
     */
    private String artifact;

    /**
     * 
     *             The event that happened.
     *           
     */
    private String event;

    /**
     * 
     *             The user who executed the event.
     *           
     */
    private String username;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The affected artifact, if there is one.
     *           
     * 
     * @return String
     */
    public String getArtifact()
    {
        return this.artifact;
    } //-- String getArtifact()

    /**
     * Get 
     *             The event that happened.
     *           
     * 
     * @return String
     */
    public String getEvent()
    {
        return this.event;
    } //-- String getEvent()

    /**
     * Get 
     *             The timestamp on when the event happened.
     *           
     * 
     * @return Date
     */
    public java.util.Date getEventDate()
    {
        return this.eventDate;
    } //-- java.util.Date getEventDate()

    /**
     * Get 
     *             The repository id where the operation was done.
     *           
     * 
     * @return String
     */
    public String getRepositoryId()
    {
        return this.repositoryId;
    } //-- String getRepositoryId()

    /**
     * Get 
     *             The user who executed the event.
     *           
     * 
     * @return String
     */
    public String getUsername()
    {
        return this.username;
    } //-- String getUsername()

    /**
     * Set 
     *             The affected artifact, if there is one.
     *           
     * 
     * @param artifact
     */
    public void setArtifact( String artifact )
    {
        this.artifact = artifact;
    } //-- void setArtifact( String )

    /**
     * Set 
     *             The event that happened.
     *           
     * 
     * @param event
     */
    public void setEvent( String event )
    {
        this.event = event;
    } //-- void setEvent( String )

    /**
     * Set 
     *             The timestamp on when the event happened.
     *           
     * 
     * @param eventDate
     */
    public void setEventDate( java.util.Date eventDate )
    {
        this.eventDate = eventDate;
    } //-- void setEventDate( java.util.Date )

    /**
     * Set 
     *             The repository id where the operation was done.
     *           
     * 
     * @param repositoryId
     */
    public void setRepositoryId( String repositoryId )
    {
        this.repositoryId = repositoryId;
    } //-- void setRepositoryId( String )

    /**
     * Set 
     *             The user who executed the event.
     *           
     * 
     * @param username
     */
    public void setUsername( String username )
    {
        this.username = username;
    } //-- void setUsername( String )


    private static final long serialVersionUID = -7113629916828442780L;
          
}
