/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class Scm.
 * 
 * @version $Revision$ $Date$
 */
public class Scm
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *               The source control management system URL
     *               that describes the repository and how to
     * connect to the
     *               repository. For more information, see the
     *               <a
     * href="http://maven.apache.org/scm/scm-url-format.html">URL
     * format</a>
     *               and <a
     * href="http://maven.apache.org/scm/scms-overview.html">list
     * of supported SCMs</a>.
     *               This connection is read-only.
     *           
     */
    private String connection;

    /**
     * 
     *             Just like <code>connection</code>, but for
     * developers, i.e. this scm connection
     *             will not be read only.
     *           
     */
    private String developerConnection;

    /**
     * 
     *             The URL to the project's browsable SCM
     * repository, such as ViewVC or Fisheye.
     */
    private String url;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *               The source control management system URL
     *               that describes the repository and how to
     * connect to the
     *               repository. For more information, see the
     *               <a
     * href="http://maven.apache.org/scm/scm-url-format.html">URL
     * format</a>
     *               and <a
     * href="http://maven.apache.org/scm/scms-overview.html">list
     * of supported SCMs</a>.
     *               This connection is read-only.
     *           
     * 
     * @return String
     */
    public String getConnection()
    {
        return this.connection;
    } //-- String getConnection()

    /**
     * Get 
     *             Just like <code>connection</code>, but for
     * developers, i.e. this scm connection
     *             will not be read only.
     *           
     * 
     * @return String
     */
    public String getDeveloperConnection()
    {
        return this.developerConnection;
    } //-- String getDeveloperConnection()

    /**
     * Get 
     *             The URL to the project's browsable SCM
     * repository, such as ViewVC or Fisheye.
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl()

    /**
     * Set 
     *               The source control management system URL
     *               that describes the repository and how to
     * connect to the
     *               repository. For more information, see the
     *               <a
     * href="http://maven.apache.org/scm/scm-url-format.html">URL
     * format</a>
     *               and <a
     * href="http://maven.apache.org/scm/scms-overview.html">list
     * of supported SCMs</a>.
     *               This connection is read-only.
     *           
     * 
     * @param connection
     */
    public void setConnection( String connection )
    {
        this.connection = connection;
    } //-- void setConnection( String )

    /**
     * Set 
     *             Just like <code>connection</code>, but for
     * developers, i.e. this scm connection
     *             will not be read only.
     *           
     * 
     * @param developerConnection
     */
    public void setDeveloperConnection( String developerConnection )
    {
        this.developerConnection = developerConnection;
    } //-- void setDeveloperConnection( String )

    /**
     * Set 
     *             The URL to the project's browsable SCM
     * repository, such as ViewVC or Fisheye.
     * 
     * @param url
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String )


    private static final long serialVersionUID = 4075086167850885575L;
          
}
