/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class CiManagement.
 * 
 * @version $Revision$ $Date$
 */
public class CiManagement
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The generated id for the CI management object.
     * Due to problems in upgrading, 
     *           we cannot unset this as the identifier and we
     * cannot rename this as well.
     */
    private String url;

    /**
     * 
     *             URL for the continuous integration system used
     * by the project if it has a web interface.
     */
    private String ciUrl;

    /**
     * 
     *             The name of the continuous integration system,
     * e.g. <code>continuum</code>.
     */
    private String system;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof CiManagement ) )
        {
            return false;
        }

        CiManagement that = (CiManagement) other;
        boolean result = true;

        result = result && ( getUrl() == null ? that.getUrl() == null : getUrl().equals( that.getUrl() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get 
     *             URL for the continuous integration system used
     * by the project if it has a web interface.
     * 
     * @return String
     */
    public String getCiUrl()
    {
        return this.ciUrl;
    } //-- String getCiUrl()

    /**
     * Get 
     *             The name of the continuous integration system,
     * e.g. <code>continuum</code>.
     * 
     * @return String
     */
    public String getSystem()
    {
        return this.system;
    } //-- String getSystem()

    /**
     * Get 
     *             The generated id for the CI management object.
     * Due to problems in upgrading, 
     *           we cannot unset this as the identifier and we
     * cannot rename this as well.
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( url != null ? url.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Set 
     *             URL for the continuous integration system used
     * by the project if it has a web interface.
     * 
     * @param ciUrl
     */
    public void setCiUrl( String ciUrl )
    {
        this.ciUrl = ciUrl;
    } //-- void setCiUrl( String )

    /**
     * Set 
     *             The name of the continuous integration system,
     * e.g. <code>continuum</code>.
     * 
     * @param system
     */
    public void setSystem( String system )
    {
        this.system = system;
    } //-- void setSystem( String )

    /**
     * Set 
     *             The generated id for the CI management object.
     * Due to problems in upgrading, 
     *           we cannot unset this as the identifier and we
     * cannot rename this as well.
     * 
     * @param url
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "url = '" );
        buf.append( getUrl() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


    private static final long serialVersionUID = 7592740408468517476L;
          
}
