/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         Information about the issue tracking (or bug tracking)
 * system used to manage this project.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class IssueManagement
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The generated id for the issue management object. Due to
     * problems in upgrading, 
     *           we cannot unset this as the identifier and we
     * cannot rename this as well.
     */
    private String url;

    /**
     * URL for the issue management system used by the project.
     */
    private String issueManagementUrl;

    /**
     * The name of the issue management system, e.g. Bugzilla.
     */
    private String system;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof IssueManagement ) )
        {
            return false;
        }

        IssueManagement that = (IssueManagement) other;
        boolean result = true;

        result = result && ( getUrl() == null ? that.getUrl() == null : getUrl().equals( that.getUrl() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get uRL for the issue management system used by the project.
     * 
     * @return String
     */
    public String getIssueManagementUrl()
    {
        return this.issueManagementUrl;
    } //-- String getIssueManagementUrl()

    /**
     * Get the name of the issue management system, e.g. Bugzilla.
     * 
     * @return String
     */
    public String getSystem()
    {
        return this.system;
    } //-- String getSystem()

    /**
     * Get the generated id for the issue management object. Due to
     * problems in upgrading, 
     *           we cannot unset this as the identifier and we
     * cannot rename this as well.
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( url != null ? url.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Set uRL for the issue management system used by the project.
     * 
     * @param issueManagementUrl
     */
    public void setIssueManagementUrl( String issueManagementUrl )
    {
        this.issueManagementUrl = issueManagementUrl;
    } //-- void setIssueManagementUrl( String )

    /**
     * Set the name of the issue management system, e.g. Bugzilla.
     * 
     * @param system
     */
    public void setSystem( String system )
    {
        this.system = system;
    } //-- void setSystem( String )

    /**
     * Set the generated id for the issue management object. Due to
     * problems in upgrading, 
     *           we cannot unset this as the identifier and we
     * cannot rename this as well.
     * 
     * @param url
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "url = '" );
        buf.append( getUrl() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


    private static final long serialVersionUID = -8881904886381224821L;
          
}
