/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * The Snapshot Version
 * 
 * @version $Revision$ $Date$
 */
public class SnapshotVersion implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field timestamp
     */
    private String timestamp;

    /**
     * Field buildNumber
     */
    private int buildNumber = 0;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get The incremental build number of the snapshot.
     */
    public int getBuildNumber()
    {
        return this.buildNumber;
    } //-- int getBuildNumber() 

    /**
     * Get 
     *             The unique timestamp for the snapshot version.
     *           
     */
    public String getTimestamp()
    {
        return this.timestamp;
    } //-- String getTimestamp() 

    /**
     * Set The incremental build number of the snapshot.
     * 
     * @param buildNumber
     */
    public void setBuildNumber(int buildNumber)
    {
        this.buildNumber = buildNumber;
    } //-- void setBuildNumber(int) 

    /**
     * Set 
     *             The unique timestamp for the snapshot version.
     *           
     * 
     * @param timestamp
     */
    public void setTimestamp(String timestamp)
    {
        this.timestamp = timestamp;
    } //-- void setTimestamp(String) 


    private static final long serialVersionUID = -1251466956496493405L;
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
