/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class Scm implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field connection
     */
    private String connection;

    /**
     * Field developerConnection
     */
    private String developerConnection;

    /**
     * Field url
     */
    private String url;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *               The source control management system URL
     *               that describes the repository and how to
     * connect to the
     *               repository. For more information, see the
     *               <a
     * href="http://maven.apache.org/scm/scm-url-format.html">URL
     * format</a>
     *               and <a
     * href="http://maven.apache.org/scm/scms-overview.html">list
     * of supported SCMs</a>.
     *               This connection is read-only.
     *           
     */
    public String getConnection()
    {
        return this.connection;
    } //-- String getConnection() 

    /**
     * Get 
     *             Just like <code>connection</code>, but for
     * developers, i.e. this scm connection
     *             will not be read only.
     *           
     */
    public String getDeveloperConnection()
    {
        return this.developerConnection;
    } //-- String getDeveloperConnection() 

    /**
     * Get 
     *             The URL to the project's browsable SCM
     * repository, such as ViewVC or Fisheye.
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Set 
     *               The source control management system URL
     *               that describes the repository and how to
     * connect to the
     *               repository. For more information, see the
     *               <a
     * href="http://maven.apache.org/scm/scm-url-format.html">URL
     * format</a>
     *               and <a
     * href="http://maven.apache.org/scm/scms-overview.html">list
     * of supported SCMs</a>.
     *               This connection is read-only.
     *           
     * 
     * @param connection
     */
    public void setConnection(String connection)
    {
        this.connection = connection;
    } //-- void setConnection(String) 

    /**
     * Set 
     *             Just like <code>connection</code>, but for
     * developers, i.e. this scm connection
     *             will not be read only.
     *           
     * 
     * @param developerConnection
     */
    public void setDeveloperConnection(String developerConnection)
    {
        this.developerConnection = developerConnection;
    } //-- void setDeveloperConnection(String) 

    /**
     * Set 
     *             The URL to the project's browsable SCM
     * repository, such as ViewVC or Fisheye.
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 


    private static final long serialVersionUID = 4075086167850885575L;
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
