/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A reference to another (unversioned) Project
 * 
 * @version $Revision$ $Date$
 */
public class ProjectReference implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The Artifact ID of the project reference.
     *           
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get 
     *             The Group ID of the project reference.
     *           
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Set 
     *             The Artifact ID of the project reference.
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set 
     *             The Group ID of the project reference.
     *           
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 


    private static final long serialVersionUID = 8947981859537138991L;
          
    private static String defaultString( String value )
    {
        if ( value == null )
        {
            return "";
        }
        
        return value.trim();
    }
          
    public static String toKey( ProjectReference reference )
    {
        StringBuffer key = new StringBuffer();

        key.append( defaultString( reference.getGroupId() ) ).append( ":" );
        key.append( defaultString( reference.getArtifactId() ) ).append( ":" );

        return key.toString();
    }
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
