/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Specifies the organization that produces this project.
 * 
 * @version $Revision$ $Date$
 */
public class Organization implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name
     */
    private String name;

    /**
     * Field url
     */
    private String url;

    /**
     * Field favicon
     */
    private String favicon;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof Organization) )
        {
            return false;
        }
        
        Organization that = (Organization) other;
        boolean result = true;
        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get 
     *             The URL to the organization's logo image.  This
     * can be an URL relative
     *             to the base directory of the generated web site,
     *             (e.g., <code>/images/org-logo.png</code>) or an
     * absolute URL
     *             (e.g., <code>http://my.corp/logo.png</code>). 
     * This value is used
     *             when generating the project documentation.
     *           
     */
    public String getFavicon()
    {
        return this.favicon;
    } //-- String getFavicon() 

    /**
     * Get The full name of the organization.
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get The URL to the organization's home page.
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( name != null ? name.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Set 
     *             The URL to the organization's logo image.  This
     * can be an URL relative
     *             to the base directory of the generated web site,
     *             (e.g., <code>/images/org-logo.png</code>) or an
     * absolute URL
     *             (e.g., <code>http://my.corp/logo.png</code>). 
     * This value is used
     *             when generating the project documentation.
     *           
     * 
     * @param favicon
     */
    public void setFavicon(String favicon)
    {
        this.favicon = favicon;
    } //-- void setFavicon(String) 

    /**
     * Set The full name of the organization.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set The URL to the organization's home page.
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "name = '" );
        buf.append( getName() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private static final long serialVersionUID = -7782212828768434535L;
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
