/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         Describes the licenses for this project.  This is used
 * to generate
 *         the license page of the project's web site, as well as
 * being taken into consideration in other reporting and
 *         validation. The licenses listed for the project are that
 * of the project itself, and not of dependencies.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class License implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private int id = 0;

    /**
     * Field name
     */
    private String name;

    /**
     * Field url
     */
    private String url;

    /**
     * Field comments
     */
    private String comments;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof License) )
        {
            return false;
        }
        
        License that = (License) other;
        boolean result = true;
        result = result && id== that.id;
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get 
     *             Addendum information pertaining to this license.
     *           
     */
    public String getComments()
    {
        return this.comments;
    } //-- String getComments() 

    /**
     * Get 
     *             The type of license.
     *           
     */
    public int getId()
    {
        return this.id;
    } //-- int getId() 

    /**
     * Get The full legal name of the license.
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get The official url for the license text.
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + (int) id;
        return result;
    } //-- int hashCode() 

    /**
     * Set 
     *             Addendum information pertaining to this license.
     *           
     * 
     * @param comments
     */
    public void setComments(String comments)
    {
        this.comments = comments;
    } //-- void setComments(String) 

    /**
     * Set 
     *             The type of license.
     *           
     * 
     * @param id
     */
    public void setId(int id)
    {
        this.id = id;
    } //-- void setId(int) 

    /**
     * Set The full legal name of the license.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set The official url for the license text.
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "id = '" );
        buf.append( getId() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private static final long serialVersionUID = 6078130909089038238L;
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
