/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class CiManagement implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field url
     */
    private String url;

    /**
     * Field system
     */
    private String system;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof CiManagement) )
        {
            return false;
        }
        
        CiManagement that = (CiManagement) other;
        boolean result = true;
        result = result && ( getUrl() == null ? that.getUrl() == null : getUrl().equals( that.getUrl() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get 
     *             The name of the continuous integration system,
     * e.g. <code>continuum</code>.
     */
    public String getSystem()
    {
        return this.system;
    } //-- String getSystem() 

    /**
     * Get 
     *             URL for the continuous integration system used
     * by the project if it has a web interface.
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( url != null ? url.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Set 
     *             The name of the continuous integration system,
     * e.g. <code>continuum</code>.
     * 
     * @param system
     */
    public void setSystem(String system)
    {
        this.system = system;
    } //-- void setSystem(String) 

    /**
     * Set 
     *             URL for the continuous integration system used
     * by the project if it has a web interface.
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "url = '" );
        buf.append( getUrl() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private static final long serialVersionUID = 7592740408468517476L;
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
