/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class ArchivaArtifactModel implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;

    /**
     * Field classifier
     */
    private String classifier;

    /**
     * Field type
     */
    private String type;

    /**
     * Field repositoryId
     */
    private String repositoryId;

    /**
     * Field snapshot
     */
    private boolean snapshot = false;

    /**
     * Field checksumMD5
     */
    private String checksumMD5;

    /**
     * Field checksumSHA1
     */
    private String checksumSHA1;

    /**
     * Field lastModified
     */
    private java.util.Date lastModified;

    /**
     * Field size
     */
    private long size = 0;

    /**
     * Field platform
     */
    private String platform = "java";

    /**
     * Field whenIndexed
     */
    private java.util.Date whenIndexed;

    /**
     * Field whenProcessed
     */
    private java.util.Date whenProcessed;

    /**
     * Field origin
     */
    private String origin;

    /**
     * Field whenGathered
     */
    private java.util.Date whenGathered;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof ArchivaArtifactModel) )
        {
            return false;
        }
        
        ArchivaArtifactModel that = (ArchivaArtifactModel) other;
        boolean result = true;
        result = result && ( getGroupId() == null ? that.getGroupId() == null : getGroupId().equals( that.getGroupId() ) );
        result = result && ( getArtifactId() == null ? that.getArtifactId() == null : getArtifactId().equals( that.getArtifactId() ) );
        result = result && ( getVersion() == null ? that.getVersion() == null : getVersion().equals( that.getVersion() ) );
        result = result && ( getClassifier() == null ? that.getClassifier() == null : getClassifier().equals( that.getClassifier() ) );
        result = result && ( getType() == null ? that.getType() == null : getType().equals( that.getType() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get 
     *             The Artifact ID of the repository content.
     *           
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get 
     *             The MD5 checksum for the artifact file.
     *           
     */
    public String getChecksumMD5()
    {
        return this.checksumMD5;
    } //-- String getChecksumMD5() 

    /**
     * Get 
     *             The SHA1 checksum for the artifact file.
     *           
     */
    public String getChecksumSHA1()
    {
        return this.checksumSHA1;
    } //-- String getChecksumSHA1() 

    /**
     * Get 
     *             The classifier for this artifact.
     *           
     */
    public String getClassifier()
    {
        return this.classifier;
    } //-- String getClassifier() 

    /**
     * Get 
     *             The Group ID of the repository content.
     *           
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get 
     *             The Last Modified Timestamp of this artifact.
     *           
     */
    public java.util.Date getLastModified()
    {
        return this.lastModified;
    } //-- java.util.Date getLastModified() 

    /**
     * Get 
     *             The origin of this artifact. (Filesystem, Proxy,
     * Deploy)
     *           
     */
    public String getOrigin()
    {
        return this.origin;
    } //-- String getOrigin() 

    /**
     * Get 
     *             The platform of this artifact. (default: "java")
     *           
     */
    public String getPlatform()
    {
        return this.platform;
    } //-- String getPlatform() 

    /**
     * Get 
     *             The repository associated with this content.
     *           
     */
    public String getRepositoryId()
    {
        return this.repositoryId;
    } //-- String getRepositoryId() 

    /**
     * Get 
     *             The size of the artifact on disk.
     *           
     */
    public long getSize()
    {
        return this.size;
    } //-- long getSize() 

    /**
     * Get 
     *             The type of artifact.
     *           
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Get 
     *             The version of the repository content.
     *           
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Get 
     *             When this artifact was gathered or disovered
     * from the repository.
     *           
     */
    public java.util.Date getWhenGathered()
    {
        return this.whenGathered;
    } //-- java.util.Date getWhenGathered() 

    /**
     * Get 
     *             The timestamp when this artifact was indexed.
     *           
     */
    public java.util.Date getWhenIndexed()
    {
        return this.whenIndexed;
    } //-- java.util.Date getWhenIndexed() 

    /**
     * Get 
     *             When this artifact's contents was processed.
     *           
     */
    public java.util.Date getWhenProcessed()
    {
        return this.whenProcessed;
    } //-- java.util.Date getWhenProcessed() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( groupId != null ? groupId.hashCode() : 0 );
        result = 37 * result + ( artifactId != null ? artifactId.hashCode() : 0 );
        result = 37 * result + ( version != null ? version.hashCode() : 0 );
        result = 37 * result + ( classifier != null ? classifier.hashCode() : 0 );
        result = 37 * result + ( type != null ? type.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Get 
     *             True if this is a snapshot.
     *           
     */
    public boolean isSnapshot()
    {
        return this.snapshot;
    } //-- boolean isSnapshot() 

    /**
     * Set 
     *             The Artifact ID of the repository content.
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set 
     *             The MD5 checksum for the artifact file.
     *           
     * 
     * @param checksumMD5
     */
    public void setChecksumMD5(String checksumMD5)
    {
        this.checksumMD5 = checksumMD5;
    } //-- void setChecksumMD5(String) 

    /**
     * Set 
     *             The SHA1 checksum for the artifact file.
     *           
     * 
     * @param checksumSHA1
     */
    public void setChecksumSHA1(String checksumSHA1)
    {
        this.checksumSHA1 = checksumSHA1;
    } //-- void setChecksumSHA1(String) 

    /**
     * Set 
     *             The classifier for this artifact.
     *           
     * 
     * @param classifier
     */
    public void setClassifier(String classifier)
    {
        this.classifier = classifier;
    } //-- void setClassifier(String) 

    /**
     * Set 
     *             The Group ID of the repository content.
     *           
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set 
     *             The Last Modified Timestamp of this artifact.
     *           
     * 
     * @param lastModified
     */
    public void setLastModified(java.util.Date lastModified)
    {
        this.lastModified = lastModified;
    } //-- void setLastModified(java.util.Date) 

    /**
     * Set 
     *             The origin of this artifact. (Filesystem, Proxy,
     * Deploy)
     *           
     * 
     * @param origin
     */
    public void setOrigin(String origin)
    {
        this.origin = origin;
    } //-- void setOrigin(String) 

    /**
     * Set 
     *             The platform of this artifact. (default: "java")
     *           
     * 
     * @param platform
     */
    public void setPlatform(String platform)
    {
        this.platform = platform;
    } //-- void setPlatform(String) 

    /**
     * Set 
     *             The repository associated with this content.
     *           
     * 
     * @param repositoryId
     */
    public void setRepositoryId(String repositoryId)
    {
        this.repositoryId = repositoryId;
    } //-- void setRepositoryId(String) 

    /**
     * Set 
     *             The size of the artifact on disk.
     *           
     * 
     * @param size
     */
    public void setSize(long size)
    {
        this.size = size;
    } //-- void setSize(long) 

    /**
     * Set 
     *             True if this is a snapshot.
     *           
     * 
     * @param snapshot
     */
    public void setSnapshot(boolean snapshot)
    {
        this.snapshot = snapshot;
    } //-- void setSnapshot(boolean) 

    /**
     * Set 
     *             The type of artifact.
     *           
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 

    /**
     * Set 
     *             The version of the repository content.
     *           
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 

    /**
     * Set 
     *             When this artifact was gathered or disovered
     * from the repository.
     *           
     * 
     * @param whenGathered
     */
    public void setWhenGathered(java.util.Date whenGathered)
    {
        this.whenGathered = whenGathered;
    } //-- void setWhenGathered(java.util.Date) 

    /**
     * Set 
     *             The timestamp when this artifact was indexed.
     *           
     * 
     * @param whenIndexed
     */
    public void setWhenIndexed(java.util.Date whenIndexed)
    {
        this.whenIndexed = whenIndexed;
    } //-- void setWhenIndexed(java.util.Date) 

    /**
     * Set 
     *             When this artifact's contents was processed.
     *           
     * 
     * @param whenProcessed
     */
    public void setWhenProcessed(java.util.Date whenProcessed)
    {
        this.whenProcessed = whenProcessed;
    } //-- void setWhenProcessed(java.util.Date) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "groupId = '" );
        buf.append( getGroupId() + "'" );
        buf.append( "\n" ); 
        buf.append( "artifactId = '" );
        buf.append( getArtifactId() + "'" );
        buf.append( "\n" ); 
        buf.append( "version = '" );
        buf.append( getVersion() + "'" );
        buf.append( "\n" ); 
        buf.append( "classifier = '" );
        buf.append( getClassifier() + "'" );
        buf.append( "\n" ); 
        buf.append( "type = '" );
        buf.append( getType() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private static final long serialVersionUID = -6292417108113887384L;
          
    /**
     * Identify if this artifact's contents have been processed or not.
     * 
     * @return true if the artifact's contents have been processed.
     */
    public boolean isProcessed()
    {
        return !(whenProcessed == null);
    }          
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
