/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         This object is only used for the XML backup / restore
 * features of Archiva.
 *         This object is not serialized to the Database.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ArchivaAll implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field artifacts
     */
    private java.util.List artifacts;

    /**
     * Field repositoryMetadata
     */
    private java.util.List repositoryMetadata;

    /**
     * Field projects
     */
    private java.util.List projects;

    /**
     * Field repositoryProblems
     */
    private java.util.List repositoryProblems;

    /**
     * Field repositoryContentStatistics
     */
    private java.util.List repositoryContentStatistics;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addArtifact
     * 
     * @param archivaArtifactModel
     */
    public void addArtifact(ArchivaArtifactModel archivaArtifactModel)
    {
        if ( !(archivaArtifactModel instanceof ArchivaArtifactModel) )
        {
            throw new ClassCastException( "ArchivaAll.addArtifacts(archivaArtifactModel) parameter must be instanceof " + ArchivaArtifactModel.class.getName() );
        }
        getArtifacts().add( archivaArtifactModel );
    } //-- void addArtifact(ArchivaArtifactModel) 

    /**
     * Method addProject
     * 
     * @param archivaProjectModel
     */
    public void addProject(ArchivaProjectModel archivaProjectModel)
    {
        if ( !(archivaProjectModel instanceof ArchivaProjectModel) )
        {
            throw new ClassCastException( "ArchivaAll.addProjects(archivaProjectModel) parameter must be instanceof " + ArchivaProjectModel.class.getName() );
        }
        getProjects().add( archivaProjectModel );
    } //-- void addProject(ArchivaProjectModel) 

    /**
     * Method addRepositoryContentStatistic
     * 
     * @param repositoryContentStatistics
     */
    public void addRepositoryContentStatistic(RepositoryContentStatistics repositoryContentStatistics)
    {
        if ( !(repositoryContentStatistics instanceof RepositoryContentStatistics) )
        {
            throw new ClassCastException( "ArchivaAll.addRepositoryContentStatistics(repositoryContentStatistics) parameter must be instanceof " + RepositoryContentStatistics.class.getName() );
        }
        getRepositoryContentStatistics().add( repositoryContentStatistics );
    } //-- void addRepositoryContentStatistic(RepositoryContentStatistics) 

    /**
     * Method addRepositoryMetadata
     * 
     * @param archivaRepositoryMetadata
     */
    public void addRepositoryMetadata(ArchivaRepositoryMetadata archivaRepositoryMetadata)
    {
        if ( !(archivaRepositoryMetadata instanceof ArchivaRepositoryMetadata) )
        {
            throw new ClassCastException( "ArchivaAll.addRepositoryMetadata(archivaRepositoryMetadata) parameter must be instanceof " + ArchivaRepositoryMetadata.class.getName() );
        }
        getRepositoryMetadata().add( archivaRepositoryMetadata );
    } //-- void addRepositoryMetadata(ArchivaRepositoryMetadata) 

    /**
     * Method addRepositoryProblem
     * 
     * @param repositoryProblem
     */
    public void addRepositoryProblem(RepositoryProblem repositoryProblem)
    {
        if ( !(repositoryProblem instanceof RepositoryProblem) )
        {
            throw new ClassCastException( "ArchivaAll.addRepositoryProblems(repositoryProblem) parameter must be instanceof " + RepositoryProblem.class.getName() );
        }
        getRepositoryProblems().add( repositoryProblem );
    } //-- void addRepositoryProblem(RepositoryProblem) 

    /**
     * Method getArtifacts
     */
    public java.util.List getArtifacts()
    {
        if ( this.artifacts == null )
        {
            this.artifacts = new java.util.ArrayList();
        }
        
        return this.artifacts;
    } //-- java.util.List getArtifacts() 

    /**
     * Method getProjects
     */
    public java.util.List getProjects()
    {
        if ( this.projects == null )
        {
            this.projects = new java.util.ArrayList();
        }
        
        return this.projects;
    } //-- java.util.List getProjects() 

    /**
     * Method getRepositoryContentStatistics
     */
    public java.util.List getRepositoryContentStatistics()
    {
        if ( this.repositoryContentStatistics == null )
        {
            this.repositoryContentStatistics = new java.util.ArrayList();
        }
        
        return this.repositoryContentStatistics;
    } //-- java.util.List getRepositoryContentStatistics() 

    /**
     * Method getRepositoryMetadata
     */
    public java.util.List getRepositoryMetadata()
    {
        if ( this.repositoryMetadata == null )
        {
            this.repositoryMetadata = new java.util.ArrayList();
        }
        
        return this.repositoryMetadata;
    } //-- java.util.List getRepositoryMetadata() 

    /**
     * Method getRepositoryProblems
     */
    public java.util.List getRepositoryProblems()
    {
        if ( this.repositoryProblems == null )
        {
            this.repositoryProblems = new java.util.ArrayList();
        }
        
        return this.repositoryProblems;
    } //-- java.util.List getRepositoryProblems() 

    /**
     * Method removeArtifact
     * 
     * @param archivaArtifactModel
     */
    public void removeArtifact(ArchivaArtifactModel archivaArtifactModel)
    {
        if ( !(archivaArtifactModel instanceof ArchivaArtifactModel) )
        {
            throw new ClassCastException( "ArchivaAll.removeArtifacts(archivaArtifactModel) parameter must be instanceof " + ArchivaArtifactModel.class.getName() );
        }
        getArtifacts().remove( archivaArtifactModel );
    } //-- void removeArtifact(ArchivaArtifactModel) 

    /**
     * Method removeProject
     * 
     * @param archivaProjectModel
     */
    public void removeProject(ArchivaProjectModel archivaProjectModel)
    {
        if ( !(archivaProjectModel instanceof ArchivaProjectModel) )
        {
            throw new ClassCastException( "ArchivaAll.removeProjects(archivaProjectModel) parameter must be instanceof " + ArchivaProjectModel.class.getName() );
        }
        getProjects().remove( archivaProjectModel );
    } //-- void removeProject(ArchivaProjectModel) 

    /**
     * Method removeRepositoryContentStatistic
     * 
     * @param repositoryContentStatistics
     */
    public void removeRepositoryContentStatistic(RepositoryContentStatistics repositoryContentStatistics)
    {
        if ( !(repositoryContentStatistics instanceof RepositoryContentStatistics) )
        {
            throw new ClassCastException( "ArchivaAll.removeRepositoryContentStatistics(repositoryContentStatistics) parameter must be instanceof " + RepositoryContentStatistics.class.getName() );
        }
        getRepositoryContentStatistics().remove( repositoryContentStatistics );
    } //-- void removeRepositoryContentStatistic(RepositoryContentStatistics) 

    /**
     * Method removeRepositoryMetadata
     * 
     * @param archivaRepositoryMetadata
     */
    public void removeRepositoryMetadata(ArchivaRepositoryMetadata archivaRepositoryMetadata)
    {
        if ( !(archivaRepositoryMetadata instanceof ArchivaRepositoryMetadata) )
        {
            throw new ClassCastException( "ArchivaAll.removeRepositoryMetadata(archivaRepositoryMetadata) parameter must be instanceof " + ArchivaRepositoryMetadata.class.getName() );
        }
        getRepositoryMetadata().remove( archivaRepositoryMetadata );
    } //-- void removeRepositoryMetadata(ArchivaRepositoryMetadata) 

    /**
     * Method removeRepositoryProblem
     * 
     * @param repositoryProblem
     */
    public void removeRepositoryProblem(RepositoryProblem repositoryProblem)
    {
        if ( !(repositoryProblem instanceof RepositoryProblem) )
        {
            throw new ClassCastException( "ArchivaAll.removeRepositoryProblems(repositoryProblem) parameter must be instanceof " + RepositoryProblem.class.getName() );
        }
        getRepositoryProblems().remove( repositoryProblem );
    } //-- void removeRepositoryProblem(RepositoryProblem) 

    /**
     * Set null
     * 
     * @param artifacts
     */
    public void setArtifacts(java.util.List artifacts)
    {
        this.artifacts = artifacts;
    } //-- void setArtifacts(java.util.List) 

    /**
     * Set null
     * 
     * @param projects
     */
    public void setProjects(java.util.List projects)
    {
        this.projects = projects;
    } //-- void setProjects(java.util.List) 

    /**
     * Set null
     * 
     * @param repositoryContentStatistics
     */
    public void setRepositoryContentStatistics(java.util.List repositoryContentStatistics)
    {
        this.repositoryContentStatistics = repositoryContentStatistics;
    } //-- void setRepositoryContentStatistics(java.util.List) 

    /**
     * Set null
     * 
     * @param repositoryMetadata
     */
    public void setRepositoryMetadata(java.util.List repositoryMetadata)
    {
        this.repositoryMetadata = repositoryMetadata;
    } //-- void setRepositoryMetadata(java.util.List) 

    /**
     * Set null
     * 
     * @param repositoryProblems
     */
    public void setRepositoryProblems(java.util.List repositoryProblems)
    {
        this.repositoryProblems = repositoryProblems;
    } //-- void setRepositoryProblems(java.util.List) 


    private static final long serialVersionUID = 3259707008803111764L;
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
