/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class RepositoryContentStatistics implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field repositoryId
     */
    private String repositoryId;

    /**
     * Field whenGathered
     */
    private java.util.Date whenGathered;

    /**
     * Field duration
     */
    private long duration = 0;

    /**
     * Field totalFileCount
     */
    private long totalFileCount = 0;

    /**
     * Field newFileCount
     */
    private long newFileCount = 0;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The duration (in milliseconds) for the gathering
     * of the statistics.
     *           
     */
    public long getDuration()
    {
        return this.duration;
    } //-- long getDuration() 

    /**
     * Get 
     *             The number of new files discovered.
     *           
     */
    public long getNewFileCount()
    {
        return this.newFileCount;
    } //-- long getNewFileCount() 

    /**
     * Get 
     *             The repository id the statistics belong to.
     *           
     */
    public String getRepositoryId()
    {
        return this.repositoryId;
    } //-- String getRepositoryId() 

    /**
     * Get 
     *             The total number of files in the repository.
     *           
     */
    public long getTotalFileCount()
    {
        return this.totalFileCount;
    } //-- long getTotalFileCount() 

    /**
     * Get 
     *             The timestamp on when this set of statistics was
     * gathered.
     *           
     */
    public java.util.Date getWhenGathered()
    {
        return this.whenGathered;
    } //-- java.util.Date getWhenGathered() 

    /**
     * Set 
     *             The duration (in milliseconds) for the gathering
     * of the statistics.
     *           
     * 
     * @param duration
     */
    public void setDuration(long duration)
    {
        this.duration = duration;
    } //-- void setDuration(long) 

    /**
     * Set 
     *             The number of new files discovered.
     *           
     * 
     * @param newFileCount
     */
    public void setNewFileCount(long newFileCount)
    {
        this.newFileCount = newFileCount;
    } //-- void setNewFileCount(long) 

    /**
     * Set 
     *             The repository id the statistics belong to.
     *           
     * 
     * @param repositoryId
     */
    public void setRepositoryId(String repositoryId)
    {
        this.repositoryId = repositoryId;
    } //-- void setRepositoryId(String) 

    /**
     * Set 
     *             The total number of files in the repository.
     *           
     * 
     * @param totalFileCount
     */
    public void setTotalFileCount(long totalFileCount)
    {
        this.totalFileCount = totalFileCount;
    } //-- void setTotalFileCount(long) 

    /**
     * Set 
     *             The timestamp on when this set of statistics was
     * gathered.
     *           
     * 
     * @param whenGathered
     */
    public void setWhenGathered(java.util.Date whenGathered)
    {
        this.whenGathered = whenGathered;
    } //-- void setWhenGathered(java.util.Date) 


    private static final long serialVersionUID = -7113629916828442780L;
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
