/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class ProjectRepository implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field name
     */
    private String name;

    /**
     * Field url
     */
    private String url;

    /**
     * Field layout
     */
    private String layout = "default";

    /**
     * Field plugins
     */
    private boolean plugins = false;

    /**
     * Field releases
     */
    private boolean releases = false;

    /**
     * Field snapshots
     */
    private boolean snapshots = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             A unique identifier for a repository. This is
     * used to match the repository to configuration in
     *             the <code>settings.xml</code> file, for example.
     *           
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get 
     *             The type of layout this repository uses for
     * locating and storing artifacts - can be <code>legacy</code>
     * or
     *             <code>default</code>.
     *           
     */
    public String getLayout()
    {
        return this.layout;
    } //-- String getLayout() 

    /**
     * Get 
     *             Human readable name of the repository.
     *           
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get 
     *              The url of the repository, in the form
     * <code>protocol://hostname/path</code>.
     *           
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Get 
     *             Flag indicating if this repository is for plugin
     * resolution.
     *           
     */
    public boolean isPlugins()
    {
        return this.plugins;
    } //-- boolean isPlugins() 

    /**
     * Get 
     *             Flag indicating if this repository has release
     * versioned artifacts.
     *           
     */
    public boolean isReleases()
    {
        return this.releases;
    } //-- boolean isReleases() 

    /**
     * Get 
     *             Flag indicating if this repository has snapshot
     * versioned artifacts.
     *           
     */
    public boolean isSnapshots()
    {
        return this.snapshots;
    } //-- boolean isSnapshots() 

    /**
     * Set 
     *             A unique identifier for a repository. This is
     * used to match the repository to configuration in
     *             the <code>settings.xml</code> file, for example.
     *           
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     *             The type of layout this repository uses for
     * locating and storing artifacts - can be <code>legacy</code>
     * or
     *             <code>default</code>.
     *           
     * 
     * @param layout
     */
    public void setLayout(String layout)
    {
        this.layout = layout;
    } //-- void setLayout(String) 

    /**
     * Set 
     *             Human readable name of the repository.
     *           
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set 
     *             Flag indicating if this repository is for plugin
     * resolution.
     *           
     * 
     * @param plugins
     */
    public void setPlugins(boolean plugins)
    {
        this.plugins = plugins;
    } //-- void setPlugins(boolean) 

    /**
     * Set 
     *             Flag indicating if this repository has release
     * versioned artifacts.
     *           
     * 
     * @param releases
     */
    public void setReleases(boolean releases)
    {
        this.releases = releases;
    } //-- void setReleases(boolean) 

    /**
     * Set 
     *             Flag indicating if this repository has snapshot
     * versioned artifacts.
     *           
     * 
     * @param snapshots
     */
    public void setSnapshots(boolean snapshots)
    {
        this.snapshots = snapshots;
    } //-- void setSnapshots(boolean) 

    /**
     * Set 
     *              The url of the repository, in the form
     * <code>protocol://hostname/path</code>.
     *           
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 


    private static final long serialVersionUID = 8906309721278091848L;
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
