/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A Mailing List
 * 
 * @version $Revision$ $Date$
 */
public class MailingList implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name
     */
    private String name;

    /**
     * Field subscribeAddress
     */
    private String subscribeAddress;

    /**
     * Field unsubscribeAddress
     */
    private String unsubscribeAddress;

    /**
     * Field postAddress
     */
    private String postAddress;

    /**
     * Field mainArchiveUrl
     */
    private String mainArchiveUrl;

    /**
     * Field otherArchives
     */
    private java.util.List otherArchives;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addOtherArchive
     * 
     * @param string
     */
    public void addOtherArchive(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "MailingList.addOtherArchives(string) parameter must be instanceof " + String.class.getName() );
        }
        getOtherArchives().add( string );
    } //-- void addOtherArchive(String) 

    /**
     * Get The url to the archive for this mailing list.
     */
    public String getMainArchiveUrl()
    {
        return this.mainArchiveUrl;
    } //-- String getMainArchiveUrl() 

    /**
     * Get The name of the mailing list.
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Method getOtherArchives
     */
    public java.util.List getOtherArchives()
    {
        if ( this.otherArchives == null )
        {
            this.otherArchives = new java.util.ArrayList();
        }
        
        return this.otherArchives;
    } //-- java.util.List getOtherArchives() 

    /**
     * Get The email address to post to this mailing list.
     */
    public String getPostAddress()
    {
        return this.postAddress;
    } //-- String getPostAddress() 

    /**
     * Get The email address to subscribe to this mailing list.
     */
    public String getSubscribeAddress()
    {
        return this.subscribeAddress;
    } //-- String getSubscribeAddress() 

    /**
     * Get The email address to unsubscribe to this mailing list.
     */
    public String getUnsubscribeAddress()
    {
        return this.unsubscribeAddress;
    } //-- String getUnsubscribeAddress() 

    /**
     * Method removeOtherArchive
     * 
     * @param string
     */
    public void removeOtherArchive(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "MailingList.removeOtherArchives(string) parameter must be instanceof " + String.class.getName() );
        }
        getOtherArchives().remove( string );
    } //-- void removeOtherArchive(String) 

    /**
     * Set The url to the archive for this mailing list.
     * 
     * @param mainArchiveUrl
     */
    public void setMainArchiveUrl(String mainArchiveUrl)
    {
        this.mainArchiveUrl = mainArchiveUrl;
    } //-- void setMainArchiveUrl(String) 

    /**
     * Set The name of the mailing list.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set The email address to subscribe to this mailing list.
     * 
     * @param otherArchives
     */
    public void setOtherArchives(java.util.List otherArchives)
    {
        this.otherArchives = otherArchives;
    } //-- void setOtherArchives(java.util.List) 

    /**
     * Set The email address to post to this mailing list.
     * 
     * @param postAddress
     */
    public void setPostAddress(String postAddress)
    {
        this.postAddress = postAddress;
    } //-- void setPostAddress(String) 

    /**
     * Set The email address to subscribe to this mailing list.
     * 
     * @param subscribeAddress
     */
    public void setSubscribeAddress(String subscribeAddress)
    {
        this.subscribeAddress = subscribeAddress;
    } //-- void setSubscribeAddress(String) 

    /**
     * Set The email address to unsubscribe to this mailing list.
     * 
     * @param unsubscribeAddress
     */
    public void setUnsubscribeAddress(String unsubscribeAddress)
    {
        this.unsubscribeAddress = unsubscribeAddress;
    } //-- void setUnsubscribeAddress(String) 


    private static final long serialVersionUID = 843006855864469245L;
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
