/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         Information about the issue tracking (or bug tracking)
 * system used to manage this project.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class IssueManagement implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field url
     */
    private String url;

    /**
     * Field system
     */
    private String system;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof IssueManagement) )
        {
            return false;
        }
        
        IssueManagement that = (IssueManagement) other;
        boolean result = true;
        result = result && ( getUrl() == null ? that.getUrl() == null : getUrl().equals( that.getUrl() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get The name of the issue management system, e.g. Bugzilla
     */
    public String getSystem()
    {
        return this.system;
    } //-- String getSystem() 

    /**
     * Get URL for the issue management system used by the project.
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( url != null ? url.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Set The name of the issue management system, e.g. Bugzilla
     * 
     * @param system
     */
    public void setSystem(String system)
    {
        this.system = system;
    } //-- void setSystem(String) 

    /**
     * Set URL for the issue management system used by the project.
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "url = '" );
        buf.append( getUrl() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private static final long serialVersionUID = -8881904886381224821L;
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
