/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class ArchivaArtifactJavaDetails 
implements org.apache.maven.archiva.model.ArchivaArtifactPlatformDetails, java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;

    /**
     * Field classifier
     */
    private String classifier;

    /**
     * Field type
     */
    private String type;

    /**
     * Field checksumBytecode
     */
    private String checksumBytecode;

    /**
     * Field jdk
     */
    private String jdk;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof ArchivaArtifactJavaDetails) )
        {
            return false;
        }
        
        ArchivaArtifactJavaDetails that = (ArchivaArtifactJavaDetails) other;
        boolean result = true;
        result = result && ( getGroupId() == null ? that.getGroupId() == null : getGroupId().equals( that.getGroupId() ) );
        result = result && ( getArtifactId() == null ? that.getArtifactId() == null : getArtifactId().equals( that.getArtifactId() ) );
        result = result && ( getVersion() == null ? that.getVersion() == null : getVersion().equals( that.getVersion() ) );
        result = result && ( getClassifier() == null ? that.getClassifier() == null : getClassifier().equals( that.getClassifier() ) );
        result = result && ( getType() == null ? that.getType() == null : getType().equals( that.getType() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get 
     *             The Artifact ID of the repository content.
     *           
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get 
     *             The SHA1 checksum for the bytecode in the
     * artifact file. (Can be empty if
     *             the artifact contains no bytecode)
     *           
     */
    public String getChecksumBytecode()
    {
        return this.checksumBytecode;
    } //-- String getChecksumBytecode() 

    /**
     * Get 
     *             The classifier for this artifact.
     *           
     */
    public String getClassifier()
    {
        return this.classifier;
    } //-- String getClassifier() 

    /**
     * Get 
     *             The Group ID of the repository content.
     *           
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get 
     *             The JDK revision of the bytecode. (Can be empty
     * if the artifact contains no bytecode)
     *           
     */
    public String getJdk()
    {
        return this.jdk;
    } //-- String getJdk() 

    /**
     * Get 
     *             The type of artifact.
     *           
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Get 
     *             The version of the repository content.
     *           
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( groupId != null ? groupId.hashCode() : 0 );
        result = 37 * result + ( artifactId != null ? artifactId.hashCode() : 0 );
        result = 37 * result + ( version != null ? version.hashCode() : 0 );
        result = 37 * result + ( classifier != null ? classifier.hashCode() : 0 );
        result = 37 * result + ( type != null ? type.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Set 
     *             The Artifact ID of the repository content.
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set 
     *             The SHA1 checksum for the bytecode in the
     * artifact file. (Can be empty if
     *             the artifact contains no bytecode)
     *           
     * 
     * @param checksumBytecode
     */
    public void setChecksumBytecode(String checksumBytecode)
    {
        this.checksumBytecode = checksumBytecode;
    } //-- void setChecksumBytecode(String) 

    /**
     * Set 
     *             The classifier for this artifact.
     *           
     * 
     * @param classifier
     */
    public void setClassifier(String classifier)
    {
        this.classifier = classifier;
    } //-- void setClassifier(String) 

    /**
     * Set 
     *             The Group ID of the repository content.
     *           
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set 
     *             The JDK revision of the bytecode. (Can be empty
     * if the artifact contains no bytecode)
     *           
     * 
     * @param jdk
     */
    public void setJdk(String jdk)
    {
        this.jdk = jdk;
    } //-- void setJdk(String) 

    /**
     * Set 
     *             The type of artifact.
     *           
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 

    /**
     * Set 
     *             The version of the repository content.
     *           
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "groupId = '" );
        buf.append( getGroupId() + "'" );
        buf.append( "\n" ); 
        buf.append( "artifactId = '" );
        buf.append( getArtifactId() + "'" );
        buf.append( "\n" ); 
        buf.append( "version = '" );
        buf.append( getVersion() + "'" );
        buf.append( "\n" ); 
        buf.append( "classifier = '" );
        buf.append( getClassifier() + "'" );
        buf.append( "\n" ); 
        buf.append( "type = '" );
        buf.append( getType() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private static final long serialVersionUID = -4774236779581844880L;
          
    /**
     * Identify this implementation as a set of java details.
     * 
     * @return the Java platform string
     */
    public String getPlatform()
    {
        return "java";
    }          
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
