/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.model;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.model.CompoundKey;

public class AbstractVersionedKey
implements CompoundKey,
Serializable {
    private static final long serialVersionUID = -5389698374243146150L;
    public String groupId = "";
    public String artifactId = "";
    public String version = "";

    public AbstractVersionedKey() {
    }

    public AbstractVersionedKey(String key) {
        String[] parts = StringUtils.splitPreserveAllTokens((String)key, (String)":");
        this.groupId = parts[0];
        this.artifactId = parts[1];
        this.version = parts[2];
    }

    public String toString() {
        return StringUtils.join((Object[])new String[]{this.groupId, this.artifactId, this.version}, (char)':');
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractVersionedKey other = (AbstractVersionedKey)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

