/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.indexer.merger;

import java.util.Date;
import javax.inject.Inject;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.indexer.merger.IndexMerger;
import org.apache.archiva.indexer.merger.TemporaryGroupIndex;
import org.apache.maven.index.NexusIndexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class TemporaryGroupIndexCleaner {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private IndexMerger indexMerger;
    private NexusIndexer indexer;

    @Inject
    public TemporaryGroupIndexCleaner(PlexusSisuBridge plexusSisuBridge) throws PlexusSisuBridgeException {
        this.indexer = (NexusIndexer)plexusSisuBridge.lookup(NexusIndexer.class);
    }

    @Scheduled(fixedDelay=900000L)
    public void cleanTemporaryIndex() {
        for (TemporaryGroupIndex temporaryGroupIndex : this.indexMerger.getTemporaryGroupIndexes()) {
            if (new Date().getTime() - temporaryGroupIndex.getCreationTime() <= 3600000L) continue;
            this.indexMerger.cleanTemporaryGroupIndex(temporaryGroupIndex);
        }
    }
}

