/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.indexer.merger;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.common.plexusbridge.MavenIndexerUtils;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.indexer.merger.IndexMerger;
import org.apache.archiva.indexer.merger.IndexMergerException;
import org.apache.archiva.indexer.merger.TemporaryGroupIndex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.UnsupportedExistingLuceneIndexException;
import org.apache.maven.index.packer.IndexPacker;
import org.apache.maven.index.packer.IndexPackingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="indexMerger#default")
public class DefaultIndexMerger
implements IndexMerger {
    static final int DEFAULT_GROUP_INDEX_TTL = 30;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    private MavenIndexerUtils mavenIndexerUtils;
    private NexusIndexer indexer;
    private IndexPacker indexPacker;
    private List<TemporaryGroupIndex> temporaryGroupIndexes = new CopyOnWriteArrayList<TemporaryGroupIndex>();
    private int defaultGroupIndexTtl;

    @Inject
    public DefaultIndexMerger(PlexusSisuBridge plexusSisuBridge, MavenIndexerUtils mavenIndexerUtils) throws PlexusSisuBridgeException {
        this.indexer = (NexusIndexer)plexusSisuBridge.lookup(NexusIndexer.class);
        this.mavenIndexerUtils = mavenIndexerUtils;
        this.indexPacker = (IndexPacker)plexusSisuBridge.lookup(IndexPacker.class, "default");
    }

    @PostConstruct
    public void intialize() {
        String ttlStr = System.getProperty("archiva.tmp.group.index.ttl", Integer.toString(30));
        this.defaultGroupIndexTtl = NumberUtils.toInt((String)ttlStr, (int)30);
    }

    @Override
    public IndexingContext buildMergedIndex(Collection<String> repositoriesIds, boolean packIndex) throws IndexMergerException {
        File tempRepoFile = Files.createTempDir();
        tempRepoFile.deleteOnExit();
        String tempRepoId = tempRepoFile.getName();
        try {
            File indexLocation = new File(tempRepoFile, ".indexer");
            IndexingContext indexingContext = this.indexer.addIndexingContext(tempRepoId, tempRepoId, tempRepoFile, indexLocation, null, null, this.mavenIndexerUtils.getAllIndexCreators());
            for (String repoId : repositoriesIds) {
                IndexingContext idxToMerge = (IndexingContext)this.indexer.getIndexingContexts().get(repoId);
                if (idxToMerge == null) continue;
                indexingContext.merge(idxToMerge.getIndexDirectory());
            }
            indexingContext.optimize();
            if (packIndex) {
                IndexPackingRequest request = new IndexPackingRequest(indexingContext, indexLocation);
                this.indexPacker.packIndex(request);
            }
            this.temporaryGroupIndexes.add(new TemporaryGroupIndex(tempRepoFile, tempRepoId));
            return indexingContext;
        }
        catch (IOException e) {
            throw new IndexMergerException(e.getMessage(), e);
        }
        catch (UnsupportedExistingLuceneIndexException e) {
            throw new IndexMergerException(e.getMessage(), e);
        }
    }

    @Override
    @Async
    public void cleanTemporaryGroupIndex(TemporaryGroupIndex temporaryGroupIndex) {
        if (temporaryGroupIndex == null) {
            return;
        }
        try {
            File directory;
            IndexingContext indexingContext = (IndexingContext)this.indexer.getIndexingContexts().get(temporaryGroupIndex.getIndexId());
            if (indexingContext != null) {
                this.indexer.removeIndexingContext(indexingContext, true);
            }
            if ((directory = temporaryGroupIndex.getDirectory()) != null && directory.exists()) {
                FileUtils.deleteDirectory((File)directory);
            }
            this.temporaryGroupIndexes.remove(temporaryGroupIndex);
        }
        catch (IOException e) {
            this.log.warn("fail to delete temporary group index {}", (Object)temporaryGroupIndex.getIndexId(), (Object)e);
        }
    }

    @Override
    public Collection<TemporaryGroupIndex> getTemporaryGroupIndexes() {
        return this.temporaryGroupIndexes;
    }

    @Override
    public int getDefaultGroupIndexTtl() {
        return this.defaultGroupIndexTtl;
    }
}

