/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.indexer.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.model.ArchivaArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultHit {
    private String context;
    private String url;
    private String groupId;
    private String artifactId;
    private String version = "";
    private String repositoryId = "";
    private List<String> versions = new ArrayList<String>();
    private ArchivaArtifact artifact;

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlFilename() {
        return this.url.substring(this.url.lastIndexOf(47));
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setArtifact(ArchivaArtifact artifact) {
        this.artifact = artifact;
        String ver = artifact.getVersion();
        if (!this.versions.contains(ver)) {
            this.versions.add(ver);
        }
        if (StringUtils.isBlank((String)this.groupId)) {
            this.groupId = artifact.getGroupId();
        }
        if (StringUtils.isBlank((String)this.artifactId)) {
            this.artifactId = artifact.getArtifactId();
        }
        if (StringUtils.isBlank((String)this.version)) {
            this.version = ver;
        }
    }

    public ArchivaArtifact getArtifact() {
        return this.artifact;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public void setVersions(List<String> versions) {
        this.versions = versions;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void addVersion(String version) {
        if (this.versions == null) {
            this.versions = new ArrayList<String>();
        }
        this.versions.add(version);
    }
}

