/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer.functors;

import org.apache.commons.collections.Predicate;
import org.apache.maven.archiva.indexer.RepositoryContentIndex;
import org.apache.maven.archiva.indexer.RepositoryIndexException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexExistsPredicate
implements Predicate {
    private Logger log = LoggerFactory.getLogger(IndexExistsPredicate.class);

    public boolean evaluate(Object object) {
        boolean satisfies = false;
        if (object instanceof RepositoryContentIndex) {
            RepositoryContentIndex index = (RepositoryContentIndex)object;
            try {
                satisfies = index.exists();
            }
            catch (RepositoryIndexException e) {
                this.log.info("Repository Content Index [" + index.getId() + "] for repository [" + index.getRepository().getId() + "] does not exist yet in [" + index.getIndexDirectory().getAbsolutePath() + "].");
            }
        }
        return satisfies;
    }
}

