/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer;

import org.apache.maven.archiva.indexer.RepositoryContentIndex;
import org.apache.maven.archiva.indexer.RepositoryContentIndexFactory;
import org.apache.maven.archiva.indexer.RepositoryIndexException;
import org.apache.maven.archiva.indexer.bytecode.BytecodeRecord;
import org.apache.maven.archiva.indexer.filecontent.FileContentRecord;
import org.apache.maven.archiva.indexer.hashcodes.HashcodesRecord;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.repository.ManagedRepositoryContent;
import org.apache.maven.archiva.repository.events.RepositoryListener;

public class RepositoryContentIndexEventListener
implements RepositoryListener {
    private RepositoryContentIndexFactory indexFactory;

    public void deleteArtifact(ManagedRepositoryContent repository, ArchivaArtifact artifact) {
        try {
            RepositoryContentIndex index = this.indexFactory.createFileContentIndex(repository.getRepository());
            FileContentRecord fileContentRecord = new FileContentRecord();
            fileContentRecord.setRepositoryId(repository.getRepository().getId());
            fileContentRecord.setFilename(repository.toPath(artifact));
            index.deleteRecord(fileContentRecord);
            index = this.indexFactory.createHashcodeIndex(repository.getRepository());
            HashcodesRecord hashcodesRecord = new HashcodesRecord();
            fileContentRecord.setRepositoryId(repository.getRepository().getId());
            hashcodesRecord.setArtifact(artifact);
            index.deleteRecord(hashcodesRecord);
            index = this.indexFactory.createBytecodeIndex(repository.getRepository());
            BytecodeRecord bytecodeRecord = new BytecodeRecord();
            fileContentRecord.setRepositoryId(repository.getRepository().getId());
            bytecodeRecord.setArtifact(artifact);
            index.deleteRecord(bytecodeRecord);
        }
        catch (RepositoryIndexException repositoryIndexException) {
            // empty catch block
        }
    }
}

