/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer.filecontent;

import java.text.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.maven.archiva.indexer.filecontent.FileContentRecord;
import org.apache.maven.archiva.indexer.lucene.LuceneDocumentMaker;
import org.apache.maven.archiva.indexer.lucene.LuceneEntryConverter;
import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentRecord;
import org.apache.maven.archiva.model.ArchivaArtifact;

public class FileContentConverter
implements LuceneEntryConverter {
    public Document convert(LuceneRepositoryContentRecord record) {
        if (!(record instanceof FileContentRecord)) {
            throw new ClassCastException("Unable to convert type " + record.getClass().getName() + " to " + FileContentRecord.class.getName() + ".");
        }
        FileContentRecord filecontent = (FileContentRecord)record;
        LuceneDocumentMaker doc = new LuceneDocumentMaker(filecontent);
        if (filecontent.getArtifact() != null) {
            doc.addFieldTokenized("groupId", filecontent.getArtifact().getGroupId());
            doc.addFieldExact("groupId_u", filecontent.getArtifact().getGroupId());
            doc.addFieldTokenized("artifactId", filecontent.getArtifact().getArtifactId());
            doc.addFieldExact("artifactId_u", filecontent.getArtifact().getArtifactId());
            doc.addFieldTokenized("version", filecontent.getArtifact().getVersion());
            doc.addFieldExact("version_u", filecontent.getArtifact().getVersion());
            doc.addFieldTokenized("type", filecontent.getArtifact().getType());
            doc.addFieldUntokenized("classifier", filecontent.getArtifact().getClassifier());
        }
        doc.addFieldTokenized("filename", filecontent.getFilename());
        doc.addFieldTokenized("content", filecontent.getContents());
        return doc.getDocument();
    }

    public LuceneRepositoryContentRecord convert(Document document) throws ParseException {
        FileContentRecord record = new FileContentRecord();
        record.setRepositoryId(document.get("repoId"));
        String groupId = document.get("groupId");
        String artifactId = document.get("artifactId");
        String version = document.get("version");
        String classifier = document.get("classifier");
        String type = document.get("type");
        if (StringUtils.isNotBlank((String)groupId) && StringUtils.isNotBlank((String)artifactId)) {
            ArchivaArtifact artifact = new ArchivaArtifact(groupId, artifactId, version, classifier, type);
            record.setArtifact(artifact);
        }
        record.setFilename(document.get("filename"));
        record.setContents(document.get("content"));
        return record;
    }
}

