/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer.bytecode;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.maven.archiva.indexer.bytecode.BytecodeRecord;
import org.apache.maven.archiva.indexer.lucene.LuceneDocumentMaker;
import org.apache.maven.archiva.indexer.lucene.LuceneEntryConverter;
import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentRecord;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.model.platform.JavaArtifactHelper;

public class BytecodeEntryConverter
implements LuceneEntryConverter {
    public Document convert(LuceneRepositoryContentRecord record) {
        if (!(record instanceof BytecodeRecord)) {
            throw new ClassCastException("Unable to convert type " + record.getClass().getName() + " to " + BytecodeRecord.class.getName() + ".");
        }
        BytecodeRecord bytecode = (BytecodeRecord)record;
        LuceneDocumentMaker doc = new LuceneDocumentMaker(bytecode);
        doc.addFieldTokenized("groupId", bytecode.getArtifact().getGroupId());
        doc.addFieldExact("groupId_u", bytecode.getArtifact().getGroupId());
        doc.addFieldTokenized("artifactId", bytecode.getArtifact().getArtifactId());
        doc.addFieldExact("artifactId_u", bytecode.getArtifact().getArtifactId());
        doc.addFieldTokenized("version", bytecode.getArtifact().getVersion());
        doc.addFieldExact("version_u", bytecode.getArtifact().getVersion());
        doc.addFieldTokenized("type", bytecode.getArtifact().getType());
        doc.addFieldUntokenized("classifier", bytecode.getArtifact().getClassifier());
        doc.addFieldExact("jdk", JavaArtifactHelper.getJavaDetails((ArchivaArtifact)bytecode.getArtifact()).getJdk());
        doc.addFieldTokenized("classes", bytecode.getClasses());
        doc.addFieldTokenized("methods", bytecode.getMethods());
        doc.addFieldTokenized("files", bytecode.getFiles());
        return doc.getDocument();
    }

    public LuceneRepositoryContentRecord convert(Document document) throws ParseException {
        BytecodeRecord record = new BytecodeRecord();
        record.setRepositoryId(document.get("repoId"));
        String groupId = document.get("groupId");
        String artifactId = document.get("artifactId");
        String version = document.get("version");
        String classifier = document.get("classifier");
        String type = document.get("type");
        ArchivaArtifact artifact = new ArchivaArtifact(groupId, artifactId, version, classifier, type);
        record.setArtifact(artifact);
        JavaArtifactHelper.getJavaDetails((ArchivaArtifact)record.getArtifact()).setJdk(document.get("jdk"));
        record.setClasses(this.getList(document, "classes"));
        record.setMethods(this.getList(document, "methods"));
        record.setFiles(this.getList(document, "files"));
        return record;
    }

    public List getList(Document document, String key) {
        String rawlist = document.get(key);
        if (rawlist == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(Arrays.asList(rawlist.split("\n")));
        return ret;
    }
}

