/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.Searchable;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.ConfigurationNames;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.indexer.RepositoryContentIndex;
import org.apache.maven.archiva.indexer.RepositoryContentIndexFactory;
import org.apache.maven.archiva.indexer.RepositoryIndexException;
import org.apache.maven.archiva.indexer.RepositoryIndexSearchException;
import org.apache.maven.archiva.indexer.bytecode.BytecodeHandlers;
import org.apache.maven.archiva.indexer.filecontent.FileContentHandlers;
import org.apache.maven.archiva.indexer.hashcodes.HashcodesHandlers;
import org.apache.maven.archiva.indexer.lucene.LuceneEntryConverter;
import org.apache.maven.archiva.indexer.lucene.LuceneQuery;
import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentRecord;
import org.apache.maven.archiva.indexer.search.CrossRepositorySearch;
import org.apache.maven.archiva.indexer.search.SearchResultLimits;
import org.apache.maven.archiva.indexer.search.SearchResults;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.registry.Registry;
import org.codehaus.plexus.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCrossRepositorySearch
implements CrossRepositorySearch,
RegistryListener,
Initializable {
    private Logger log = LoggerFactory.getLogger(DefaultCrossRepositorySearch.class);
    private RepositoryContentIndexFactory indexFactory;
    private ArchivaConfiguration configuration;
    private List<ManagedRepositoryConfiguration> localIndexedRepositories = new ArrayList<ManagedRepositoryConfiguration>();

    @Override
    public SearchResults searchForChecksum(String principal, List<String> selectedRepos, String checksum, SearchResultLimits limits) {
        List<RepositoryContentIndex> indexes = this.getHashcodeIndexes(principal, selectedRepos);
        try {
            MultiFieldQueryParser parser = new MultiFieldQueryParser(new String[]{"md5", "sha1"}, new HashcodesHandlers().getAnalyzer());
            LuceneQuery query = new LuceneQuery(parser.parse(checksum));
            SearchResults results = this.searchAll(query, limits, indexes, null);
            results.getRepositories().addAll(this.localIndexedRepositories);
            return results;
        }
        catch (ParseException e) {
            this.log.warn("Unable to parse query [" + checksum + "]: " + e.getMessage(), (Throwable)e);
            return new SearchResults();
        }
    }

    @Override
    public SearchResults searchForBytecode(String principal, List<String> selectedRepos, String term, SearchResultLimits limits) {
        List<RepositoryContentIndex> indexes = this.getBytecodeIndexes(principal, selectedRepos);
        try {
            QueryParser parser = new BytecodeHandlers().getQueryParser();
            LuceneQuery query = new LuceneQuery(parser.parse(term));
            SearchResults results = this.searchAll(query, limits, indexes, null);
            results.getRepositories().addAll(this.localIndexedRepositories);
            return results;
        }
        catch (ParseException e) {
            this.log.warn("Unable to parse query [" + term + "]: " + e.getMessage(), (Throwable)e);
            return new SearchResults();
        }
    }

    @Override
    public SearchResults searchForTerm(String principal, List<String> selectedRepos, String term, SearchResultLimits limits) {
        return this.searchForTerm(principal, selectedRepos, term, limits, null);
    }

    @Override
    public SearchResults searchForTerm(String principal, List<String> selectedRepos, String term, SearchResultLimits limits, List<String> previousSearchTerms) {
        List<RepositoryContentIndex> indexes = this.getFileContentIndexes(principal, selectedRepos);
        try {
            QueryParser parser = new FileContentHandlers().getQueryParser();
            LuceneQuery query = null;
            SearchResults results = null;
            if (previousSearchTerms == null || previousSearchTerms.isEmpty()) {
                query = new LuceneQuery(parser.parse(term));
                results = this.searchAll(query, limits, indexes, null);
            } else {
                BooleanQuery booleanQuery = new BooleanQuery();
                for (String previousSearchTerm : previousSearchTerms) {
                    booleanQuery.add(parser.parse(previousSearchTerm), BooleanClause.Occur.MUST);
                }
                query = new LuceneQuery((Query)booleanQuery);
                QueryWrapperFilter filter = new QueryWrapperFilter(parser.parse(term));
                results = this.searchAll(query, limits, indexes, (Filter)filter);
            }
            results.getRepositories().addAll(this.localIndexedRepositories);
            return results;
        }
        catch (ParseException e) {
            this.log.warn("Unable to parse query [" + term + "]: " + e.getMessage(), (Throwable)e);
            return new SearchResults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResults searchAll(LuceneQuery luceneQuery, SearchResultLimits limits, List<RepositoryContentIndex> indexes, Filter filter) {
        SearchResults results;
        block18: {
            Query specificQuery = luceneQuery.getLuceneQuery();
            results = new SearchResults();
            if (indexes.isEmpty()) {
                return results;
            }
            LuceneEntryConverter converter = null;
            RepositoryContentIndex index = indexes.get(0);
            converter = index.getEntryConverter();
            List<Searchable> searchableList = this.toSearchables(indexes);
            Searchable[] searchables = new Searchable[searchableList.size()];
            searchableList.toArray(searchables);
            MultiSearcher searcher = null;
            try {
                searcher = new MultiSearcher(searchables);
                Hits hits = null;
                hits = filter != null ? searcher.search(specificQuery, filter) : searcher.search(specificQuery);
                int hitCount = hits.length();
                results.setLimits(limits);
                results.setTotalHits(hitCount);
                int fetchCount = limits.getPageSize();
                int offset = limits.getSelectedPage() * limits.getPageSize();
                if (limits.getSelectedPage() == -1) {
                    fetchCount = hitCount;
                    offset = 0;
                }
                if (offset >= hitCount) break block18;
                for (int i = 0; i < fetchCount; ++i) {
                    if (offset + i >= hitCount) {
                        break;
                    }
                    try {
                        Document doc = hits.doc(offset + i);
                        LuceneRepositoryContentRecord record = converter.convert(doc);
                        results.addHit(record);
                        continue;
                    }
                    catch (java.text.ParseException e) {
                        this.log.warn("Unable to parse document into record: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                this.log.error("Unable to setup multi-search: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (searcher != null) {
                        searcher.close();
                    }
                }
                catch (IOException ie) {
                    this.log.error("Unable to close index searcher: " + ie.getMessage(), (Throwable)ie);
                }
            }
        }
        return results;
    }

    private List<Searchable> toSearchables(List<RepositoryContentIndex> indexes) {
        ArrayList<Searchable> searchableList = new ArrayList<Searchable>();
        for (RepositoryContentIndex contentIndex : indexes) {
            try {
                searchableList.add(contentIndex.getSearchable());
            }
            catch (RepositoryIndexSearchException e) {
                this.log.warn("Unable to get searchable for index [" + contentIndex.getId() + "] :" + e.getMessage(), (Throwable)e);
            }
        }
        return searchableList;
    }

    public List<RepositoryContentIndex> getBytecodeIndexes(String principal, List<String> selectedRepos) {
        ArrayList<RepositoryContentIndex> ret = new ArrayList<RepositoryContentIndex>();
        for (ManagedRepositoryConfiguration repoConfig : this.localIndexedRepositories) {
            RepositoryContentIndex index;
            if (!selectedRepos.contains(repoConfig.getId()) || !this.indexExists(index = this.indexFactory.createBytecodeIndex(repoConfig))) continue;
            ret.add(index);
        }
        return ret;
    }

    public List<RepositoryContentIndex> getFileContentIndexes(String principal, List<String> selectedRepos) {
        ArrayList<RepositoryContentIndex> ret = new ArrayList<RepositoryContentIndex>();
        for (ManagedRepositoryConfiguration repoConfig : this.localIndexedRepositories) {
            RepositoryContentIndex index;
            if (!selectedRepos.contains(repoConfig.getId()) || !this.indexExists(index = this.indexFactory.createFileContentIndex(repoConfig))) continue;
            ret.add(index);
        }
        return ret;
    }

    public List<RepositoryContentIndex> getHashcodeIndexes(String principal, List<String> selectedRepos) {
        ArrayList<RepositoryContentIndex> ret = new ArrayList<RepositoryContentIndex>();
        for (ManagedRepositoryConfiguration repoConfig : this.localIndexedRepositories) {
            RepositoryContentIndex index;
            if (!selectedRepos.contains(repoConfig.getId()) || !this.indexExists(index = this.indexFactory.createHashcodeIndex(repoConfig))) continue;
            ret.add(index);
        }
        return ret;
    }

    private boolean indexExists(RepositoryContentIndex index) {
        try {
            return index.exists();
        }
        catch (RepositoryIndexException e) {
            this.log.info("Repository Content Index [" + index.getId() + "] for repository [" + index.getRepository().getId() + "] does not exist yet in [" + index.getIndexDirectory().getAbsolutePath() + "].");
            return false;
        }
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isManagedRepositories((String)propertyName)) {
            this.initRepositories();
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepositories() {
        List<ManagedRepositoryConfiguration> list = this.localIndexedRepositories;
        synchronized (list) {
            this.localIndexedRepositories.clear();
            List repos = this.configuration.getConfiguration().getManagedRepositories();
            for (ManagedRepositoryConfiguration repo : repos) {
                if (!repo.isScanned()) continue;
                this.localIndexedRepositories.add(repo);
            }
        }
    }

    public void initialize() throws InitializationException {
        this.initRepositories();
        this.configuration.addChangeListener((RegistryListener)this);
    }
}

