/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer.lucene;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.indexer.RepositoryContentIndex;
import org.apache.maven.archiva.indexer.RepositoryIndexException;
import org.apache.maven.archiva.indexer.RepositoryIndexSearchException;
import org.apache.maven.archiva.indexer.lucene.LuceneEntryConverter;
import org.apache.maven.archiva.indexer.lucene.LuceneIndexHandlers;
import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentRecord;

public class LuceneRepositoryContentIndex
implements RepositoryContentIndex {
    private static final int MAX_FIELD_LENGTH = 40000;
    private File indexLocation;
    private LuceneIndexHandlers indexHandlers;
    private ManagedRepositoryConfiguration repository;

    public LuceneRepositoryContentIndex(ManagedRepositoryConfiguration repository, File indexDir, LuceneIndexHandlers handlers) {
        this.repository = repository;
        this.indexLocation = indexDir;
        this.indexHandlers = handlers;
    }

    public void indexRecords(Collection records) throws RepositoryIndexException {
        this.deleteRecords(records);
        this.addRecords(records);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRecords(Collection records) throws RepositoryIndexException {
        ManagedRepositoryConfiguration managedRepositoryConfiguration = this.repository;
        synchronized (managedRepositoryConfiguration) {
            IndexWriter indexWriter = null;
            try {
                indexWriter = new IndexWriter(this.indexLocation, this.indexHandlers.getAnalyzer(), !this.exists());
                indexWriter.setMaxFieldLength(40000);
                for (LuceneRepositoryContentRecord record : records) {
                    if (record == null) continue;
                    Term term = new Term("pk", record.getPrimaryKey());
                    indexWriter.deleteDocuments(term);
                    Document document = this.indexHandlers.getConverter().convert(record);
                    indexWriter.addDocument(document);
                }
                indexWriter.optimize();
            }
            catch (IOException e) {
                try {
                    throw new RepositoryIndexException("Error updating index: " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    LuceneRepositoryContentIndex.closeQuietly(indexWriter);
                    throw throwable;
                }
            }
            LuceneRepositoryContentIndex.closeQuietly(indexWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRecord(LuceneRepositoryContentRecord record) throws RepositoryIndexException {
        ManagedRepositoryConfiguration managedRepositoryConfiguration = this.repository;
        synchronized (managedRepositoryConfiguration) {
            IndexWriter indexWriter = null;
            try {
                indexWriter = new IndexWriter(this.indexLocation, this.indexHandlers.getAnalyzer(), !this.exists());
                indexWriter.setMaxFieldLength(40000);
                if (record != null) {
                    Term term = new Term("pk", record.getPrimaryKey());
                    indexWriter.deleteDocuments(term);
                    Document document = this.indexHandlers.getConverter().convert(record);
                    indexWriter.addDocument(document);
                }
                indexWriter.optimize();
            }
            catch (IOException e) {
                try {
                    throw new RepositoryIndexException("Error updating index: " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    LuceneRepositoryContentIndex.closeQuietly(indexWriter);
                    throw throwable;
                }
            }
            LuceneRepositoryContentIndex.closeQuietly(indexWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecords(Collection records) throws RepositoryIndexException {
        ManagedRepositoryConfiguration managedRepositoryConfiguration = this.repository;
        synchronized (managedRepositoryConfiguration) {
            IndexWriter indexWriter;
            try {
                indexWriter = new IndexWriter(this.indexLocation, this.indexHandlers.getAnalyzer(), !this.exists());
                indexWriter.setMaxFieldLength(40000);
            }
            catch (IOException e) {
                throw new RepositoryIndexException("Unable to open index", e);
            }
            try {
                for (LuceneRepositoryContentRecord record : records) {
                    if (record == null) continue;
                    Document document = this.indexHandlers.getConverter().convert(record);
                    indexWriter.addDocument(document);
                }
                indexWriter.optimize();
            }
            catch (IOException e) {
                throw new RepositoryIndexException("Failed to add an index document", e);
            }
            finally {
                LuceneRepositoryContentIndex.closeQuietly(indexWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecords(Collection records) throws RepositoryIndexException {
        ManagedRepositoryConfiguration managedRepositoryConfiguration = this.repository;
        synchronized (managedRepositoryConfiguration) {
            if (this.exists()) {
                IndexReader indexReader = null;
                try {
                    indexReader = IndexReader.open((File)this.indexLocation);
                    for (LuceneRepositoryContentRecord record : records) {
                        if (record == null) continue;
                        Term term = new Term("pk", record.getPrimaryKey());
                        indexReader.deleteDocuments(term);
                    }
                }
                catch (IOException e) {
                    throw new RepositoryIndexException("Error deleting document: " + e.getMessage(), e);
                }
                finally {
                    LuceneRepositoryContentIndex.closeQuietly(indexReader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(LuceneRepositoryContentRecord record) throws RepositoryIndexException {
        ManagedRepositoryConfiguration managedRepositoryConfiguration = this.repository;
        synchronized (managedRepositoryConfiguration) {
            if (this.exists()) {
                IndexReader indexReader = null;
                try {
                    indexReader = IndexReader.open((File)this.indexLocation);
                    if (record != null) {
                        Term term = new Term("pk", record.getPrimaryKey());
                        indexReader.deleteDocuments(term);
                    }
                }
                catch (IOException e) {
                    throw new RepositoryIndexException("Error deleting document: " + e.getMessage(), e);
                }
                finally {
                    LuceneRepositoryContentIndex.closeQuietly(indexReader);
                }
            }
        }
    }

    public Collection getAllRecordKeys() throws RepositoryIndexException {
        return this.getAllFieldValues("pk");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getAllFieldValues(String fieldName) throws RepositoryIndexException {
        ManagedRepositoryConfiguration managedRepositoryConfiguration = this.repository;
        synchronized (managedRepositoryConfiguration) {
            ArrayList<String> keys = new ArrayList<String>();
            if (this.exists()) {
                IndexReader indexReader = null;
                TermEnum terms = null;
                try {
                    indexReader = IndexReader.open((File)this.indexLocation);
                    terms = indexReader.terms(new Term(fieldName, ""));
                    while (fieldName.equals(terms.term().field())) {
                        keys.add(terms.term().text());
                        if (terms.next()) continue;
                    }
                }
                catch (IOException e) {
                    try {
                        throw new RepositoryIndexException("Error deleting document: " + e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        LuceneRepositoryContentIndex.closeQuietly(indexReader);
                        LuceneRepositoryContentIndex.closeQuietly(terms);
                        throw throwable;
                    }
                }
                LuceneRepositoryContentIndex.closeQuietly(indexReader);
                LuceneRepositoryContentIndex.closeQuietly(terms);
            }
            return keys;
        }
    }

    public Searchable getSearchable() throws RepositoryIndexSearchException {
        try {
            IndexSearcher searcher = new IndexSearcher(this.indexLocation.getAbsolutePath());
            return searcher;
        }
        catch (IOException e) {
            throw new RepositoryIndexSearchException("Unable to open index: " + e.getMessage(), e);
        }
    }

    public boolean exists() throws RepositoryIndexException {
        if (IndexReader.indexExists((File)this.indexLocation)) {
            return true;
        }
        if (!this.indexLocation.exists()) {
            return false;
        }
        if (this.indexLocation.isDirectory()) {
            if (this.indexLocation.listFiles().length > 1) {
                throw new RepositoryIndexException(this.indexLocation + " is not a valid index directory.");
            }
            return false;
        }
        throw new RepositoryIndexException(this.indexLocation + " is not a directory.");
    }

    public QueryParser getQueryParser() {
        return this.indexHandlers.getQueryParser();
    }

    public static void closeSearchable(Searchable searchable) {
        if (searchable != null) {
            try {
                searchable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void closeQuietly(TermEnum terms) throws RepositoryIndexException {
        if (terms != null) {
            try {
                terms.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void closeQuietly(IndexWriter indexWriter) throws RepositoryIndexException {
        try {
            if (indexWriter != null) {
                indexWriter.close();
            }
        }
        catch (IOException e) {
            throw new RepositoryIndexException(e.getMessage(), e);
        }
    }

    private static void closeQuietly(IndexReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public File getIndexDirectory() {
        return this.indexLocation;
    }

    public String getId() {
        return this.indexHandlers.getId();
    }

    public ManagedRepositoryConfiguration getRepository() {
        return this.repository;
    }

    public Analyzer getAnalyzer() {
        return this.indexHandlers.getAnalyzer();
    }

    public LuceneEntryConverter getEntryConverter() {
        return this.indexHandlers.getConverter();
    }
}

