/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.indexer.bytecode.BytecodeRecord;
import org.apache.maven.archiva.indexer.filecontent.FileContentRecord;
import org.apache.maven.archiva.indexer.hashcodes.HashcodesRecord;
import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentRecord;
import org.apache.maven.archiva.indexer.search.SearchResultHit;
import org.apache.maven.archiva.indexer.search.SearchResultLimits;
import org.apache.maven.archiva.model.ArchivaArtifact;

public class SearchResults {
    private List repositories = new ArrayList();
    private Map hits = new HashMap();
    private int totalHits;
    private SearchResultLimits limits;

    public void addHit(LuceneRepositoryContentRecord record) {
        if (record instanceof FileContentRecord) {
            FileContentRecord filecontent = (FileContentRecord)record;
            this.addFileContentHit(filecontent);
        } else if (record instanceof HashcodesRecord) {
            HashcodesRecord hashcodes = (HashcodesRecord)record;
            this.addHashcodeHit(hashcodes);
        } else if (record instanceof BytecodeRecord) {
            BytecodeRecord bytecode = (BytecodeRecord)record;
            this.addBytecodeHit(bytecode);
        }
    }

    private void addBytecodeHit(BytecodeRecord bytecode) {
        String key = this.toKey(bytecode.getArtifact());
        SearchResultHit hit = (SearchResultHit)this.hits.get(key);
        if (hit == null) {
            hit = new SearchResultHit();
        }
        hit.setRepositoryId(bytecode.getRepositoryId());
        hit.addArtifact(bytecode.getArtifact());
        hit.setContext(null);
        this.hits.put(key, hit);
    }

    private String toKey(ArchivaArtifact artifact) {
        StringBuffer key = new StringBuffer();
        key.append(StringUtils.defaultString((String)artifact.getModel().getRepositoryId())).append(":");
        key.append(StringUtils.defaultString((String)artifact.getGroupId())).append(":");
        key.append(StringUtils.defaultString((String)artifact.getArtifactId())).append(":");
        key.append(StringUtils.defaultString((String)artifact.getVersion()));
        return key.toString();
    }

    private void addHashcodeHit(HashcodesRecord hashcodes) {
        String key = this.toKey(hashcodes.getArtifact());
        SearchResultHit hit = (SearchResultHit)this.hits.get(key);
        if (hit == null) {
            hit = new SearchResultHit();
        }
        hit.addArtifact(hashcodes.getArtifact());
        hit.setContext(null);
        this.hits.put(key, hit);
    }

    public void addFileContentHit(FileContentRecord filecontent) {
        String key = filecontent.getPrimaryKey();
        SearchResultHit hit = (SearchResultHit)this.hits.get(key);
        if (hit == null) {
            hit = new SearchResultHit();
            hit.setRepositoryId(filecontent.getRepositoryId());
            hit.setUrl(filecontent.getRepositoryId() + "/" + filecontent.getFilename());
            hit.setContext(null);
            if (filecontent.getArtifact() != null) {
                hit.addArtifact(filecontent.getArtifact());
            }
            this.hits.put(key, hit);
        }
    }

    public List getHits() {
        return new ArrayList(this.hits.values());
    }

    public List getRepositories() {
        return this.repositories;
    }

    public boolean isEmpty() {
        return this.hits.isEmpty();
    }

    public void setRepositories(List repositories) {
        this.repositories = repositories;
    }

    public SearchResultLimits getLimits() {
        return this.limits;
    }

    public void setLimits(SearchResultLimits limits) {
        this.limits = limits;
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public void setTotalHits(int totalHits) {
        this.totalHits = totalHits;
    }
}

