/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer.hashcodes;

import java.text.ParseException;
import org.apache.lucene.document.Document;
import org.apache.maven.archiva.indexer.hashcodes.HashcodesRecord;
import org.apache.maven.archiva.indexer.lucene.LuceneDocumentMaker;
import org.apache.maven.archiva.indexer.lucene.LuceneEntryConverter;
import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentRecord;
import org.apache.maven.archiva.model.ArchivaArtifact;

public class HashcodesEntryConverter
implements LuceneEntryConverter {
    public Document convert(LuceneRepositoryContentRecord record) {
        if (!(record instanceof HashcodesRecord)) {
            throw new ClassCastException("Unable to convert type " + record.getClass().getName() + " to " + HashcodesRecord.class.getName() + ".");
        }
        HashcodesRecord hashcodes = (HashcodesRecord)record;
        LuceneDocumentMaker doc = new LuceneDocumentMaker(hashcodes);
        doc.addFieldTokenized("groupId", hashcodes.getArtifact().getGroupId());
        doc.addFieldExact("groupId_u", hashcodes.getArtifact().getGroupId());
        doc.addFieldTokenized("artifactId", hashcodes.getArtifact().getArtifactId());
        doc.addFieldExact("artifactId_u", hashcodes.getArtifact().getArtifactId());
        doc.addFieldTokenized("version", hashcodes.getArtifact().getVersion());
        doc.addFieldExact("version_u", hashcodes.getArtifact().getVersion());
        doc.addFieldTokenized("type", hashcodes.getArtifact().getType());
        doc.addFieldUntokenized("classifier", hashcodes.getArtifact().getClassifier());
        doc.addFieldUntokenized("md5", hashcodes.getArtifact().getModel().getChecksumMD5());
        doc.addFieldUntokenized("sha1", hashcodes.getArtifact().getModel().getChecksumSHA1());
        return doc.getDocument();
    }

    public LuceneRepositoryContentRecord convert(Document document) throws ParseException {
        HashcodesRecord record = new HashcodesRecord();
        record.setRepositoryId(document.get("repoId"));
        String groupId = document.get("groupId");
        String artifactId = document.get("artifactId");
        String version = document.get("version");
        String classifier = document.get("classifier");
        String type = document.get("type");
        ArchivaArtifact artifact = new ArchivaArtifact(groupId, artifactId, version, classifier, type);
        record.setArtifact(artifact);
        record.getArtifact().getModel().setChecksumMD5(document.get("md5"));
        record.getArtifact().getModel().setChecksumSHA1(document.get("sha1"));
        return record;
    }
}

