/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer.lucene;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.indexer.RepositoryContentIndex;
import org.apache.maven.archiva.indexer.RepositoryContentIndexFactory;
import org.apache.maven.archiva.indexer.bytecode.BytecodeHandlers;
import org.apache.maven.archiva.indexer.filecontent.FileContentHandlers;
import org.apache.maven.archiva.indexer.hashcodes.HashcodesHandlers;
import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentIndex;

public class LuceneRepositoryContentIndexFactory
implements RepositoryContentIndexFactory {
    private ArchivaConfiguration configuration;

    public RepositoryContentIndex createBytecodeIndex(ManagedRepositoryConfiguration repository) {
        File indexDir = this.toIndexDir(repository, "bytecode");
        return new LuceneRepositoryContentIndex(repository, indexDir, new BytecodeHandlers());
    }

    public RepositoryContentIndex createFileContentIndex(ManagedRepositoryConfiguration repository) {
        File indexDir = this.toIndexDir(repository, "filecontent");
        return new LuceneRepositoryContentIndex(repository, indexDir, new FileContentHandlers());
    }

    public RepositoryContentIndex createHashcodeIndex(ManagedRepositoryConfiguration repository) {
        File indexDir = this.toIndexDir(repository, "hashcodes");
        return new LuceneRepositoryContentIndex(repository, indexDir, new HashcodesHandlers());
    }

    private File toIndexDir(ManagedRepositoryConfiguration repository, String indexId) {
        File indexDir;
        ManagedRepositoryConfiguration repoConfig = this.configuration.getConfiguration().findManagedRepositoryById(repository.getId());
        if (repoConfig == null) {
            String repoPath = repository.getLocation();
            indexDir = new File(repoPath, ".index/" + indexId + "/");
        } else {
            String repoPath = repoConfig.getIndexDir();
            if (StringUtils.isBlank((String)repoPath)) {
                repoPath = repository.getLocation();
                if (!repoPath.endsWith("/")) {
                    repoPath = repoPath + "/";
                }
                repoPath = repoPath + ".index";
            }
            indexDir = new File(repoPath, "/" + indexId + "/");
        }
        return indexDir;
    }
}

