/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph.tasks;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections.iterators.ReverseListIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.dependency.graph.DependencyGraphEdge;
import org.apache.maven.archiva.dependency.graph.DependencyGraphKeys;
import org.apache.maven.archiva.dependency.graph.DependencyGraphNode;
import org.apache.maven.archiva.model.ArtifactReference;
import org.apache.maven.archiva.model.Dependency;
import org.apache.maven.archiva.model.Exclusion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyManagementStack {
    private Stack<DependencyGraphNode> depmanStack = new Stack();
    private Map<String, Rules> depMap = new HashMap<String, Rules>();

    private void generateDepMap() {
        this.depMap.clear();
        ReverseListIterator it = new ReverseListIterator(this.depmanStack);
        while (it.hasNext()) {
            DependencyGraphNode node = (DependencyGraphNode)it.next();
            this.addDependencies(node.getDependencyManagement());
        }
    }

    private void addDependencies(List<Dependency> dependencies) {
        for (Dependency dep : dependencies) {
            String key = DependencyGraphKeys.toManagementKey(dep);
            Rules merged = this.depMap.get(key);
            if (merged == null) {
                merged = new Rules();
                merged.artifact = new ArtifactReference();
                merged.artifact.setGroupId(dep.getGroupId());
                merged.artifact.setArtifactId(dep.getArtifactId());
                merged.artifact.setClassifier(dep.getClassifier());
                merged.artifact.setType(dep.getType());
            }
            merged.artifact.setVersion(dep.getVersion());
            if (StringUtils.isNotBlank((String)dep.getScope())) {
                merged.scope = dep.getScope();
            }
            merged.addAllExclusions(dep.getExclusions());
            this.depMap.put(key, merged);
        }
    }

    public Rules getRules(DependencyGraphEdge edge) {
        return this.getRules(edge.getNodeTo());
    }

    public Rules getRules(DependencyGraphNode node) {
        return this.getRules(node.getArtifact());
    }

    public Rules getRules(ArtifactReference ref) {
        String key = DependencyGraphKeys.toManagementKey(ref);
        return this.depMap.get(key);
    }

    public void push(DependencyGraphNode node) {
        this.depmanStack.push(node);
        this.generateDepMap();
    }

    public DependencyGraphNode pop() {
        DependencyGraphNode node = this.depmanStack.pop();
        this.generateDepMap();
        return node;
    }

    public void reset() {
        this.depmanStack.clear();
        this.depMap.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Rules {
        public ArtifactReference artifact;
        public String scope;
        public Set<String> exclusions = new HashSet<String>();

        public void addAllExclusions(List<Exclusion> depExclusions) {
            for (Exclusion ref : depExclusions) {
                String key = DependencyGraphKeys.toManagementKey(ref);
                this.exclusions.add(key);
            }
        }
    }
}

