/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.maven.archiva.dependency.graph.DependencyGraphEdge;
import org.apache.maven.archiva.dependency.graph.DependencyGraphNode;
import org.apache.maven.archiva.dependency.graph.functors.EdgeFromPredicate;
import org.apache.maven.archiva.dependency.graph.functors.EdgeToPredicate;
import org.apache.maven.archiva.model.ArtifactReference;

public class DependencyGraph {
    public static final int DISABLED_CYCLIC = 0;
    public static final int DISABLED_EXCLUDED = 1;
    public static final int DISABLED_OPTIONAL = 2;
    public static final int DISABLED_NEARER_DEP = 3;
    public static final int DISABLED_NEARER_EDGE = 4;
    private DependencyGraphNode rootNode;
    private Set edges = new HashSet();
    private ListOrderedMap nodes = new ListOrderedMap();

    public DependencyGraph(String groupId, String artifactId, String version) {
        ArtifactReference rootRef = new ArtifactReference();
        rootRef.setGroupId(groupId);
        rootRef.setArtifactId(artifactId);
        rootRef.setVersion(version);
        rootRef.setClassifier("");
        rootRef.setType("pom");
        this.rootNode = new DependencyGraphNode(rootRef);
    }

    public DependencyGraph(DependencyGraphNode root) {
        this.rootNode = root;
    }

    public Collection getEdges() {
        return this.edges;
    }

    public Collection getNodes() {
        return this.nodes.values();
    }

    public DependencyGraphNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(DependencyGraphNode rootNode) {
        this.rootNode = rootNode;
    }

    public void addEdge(DependencyGraphEdge edge) {
        if (edge.getNodeFrom() == null) {
            throw new IllegalArgumentException("edge.nodeFrom cannot be null.");
        }
        if (edge.getNodeTo() == null) {
            throw new IllegalArgumentException("edge.nodeTo cannot be null.");
        }
        this.edges.add(edge);
    }

    public DependencyGraphNode addNode(DependencyGraphNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Unable to add a null node.");
        }
        if (node.getArtifact() == null) {
            throw new IllegalArgumentException("Unable to add a node with a null artifact reference.");
        }
        int prevNodeIdx = this.nodes.indexOf((Object)node);
        if (prevNodeIdx >= 0) {
            DependencyGraphNode previousNode = (DependencyGraphNode)this.nodes.get(prevNodeIdx);
            if (CollectionUtils.isNotEmpty((Collection)node.getExcludes())) {
                previousNode.getExcludes().addAll(node.getExcludes());
            }
            if (CollectionUtils.isNotEmpty((Collection)node.getDependencyManagement())) {
                previousNode.getDependencyManagement().addAll(node.getDependencyManagement());
            }
            if (node.isFromParent()) {
                previousNode.setFromParent(true);
            }
            return previousNode;
        }
        this.nodes.put((Object)node.getArtifact(), (Object)node);
        return node;
    }

    public boolean hasNode(DependencyGraphNode node) {
        return this.nodes.containsKey((Object)node.getArtifact());
    }

    public boolean hasEdge(DependencyGraphEdge edge) {
        return this.edges.contains(edge);
    }

    public List getEdgesFrom(DependencyGraphNode node) {
        ArrayList ret = new ArrayList();
        CollectionUtils.select((Collection)this.edges, (Predicate)new EdgeFromPredicate(node.getArtifact()), ret);
        return ret;
    }

    public List getEdgesTo(DependencyGraphNode node) {
        ArrayList ret = new ArrayList();
        CollectionUtils.select((Collection)this.edges, (Predicate)new EdgeToPredicate(node.getArtifact()), ret);
        return ret;
    }

    public DependencyGraphNode getNode(ArtifactReference ref) {
        return (DependencyGraphNode)this.nodes.get((Object)ref);
    }

    public void removeEdge(DependencyGraphEdge edge) {
        this.edges.remove(edge);
    }

    public void removeNode(DependencyGraphNode node) {
        List edges = this.getEdgesFrom(node);
        if (!edges.isEmpty()) {
            System.out.println("Removing node left <" + edges + "> hanging <from> edges.");
        }
        if (!(edges = this.getEdgesTo(node)).isEmpty()) {
            System.out.println("Removing node left <" + edges + "> hanging <to> edges.");
        }
        this.nodes.remove((Object)node.getArtifact());
    }
}

