/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph.tasks;

import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.maven.archiva.dependency.graph.DependencyGraph;
import org.apache.maven.archiva.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.archiva.dependency.graph.DependencyGraphNode;
import org.apache.maven.archiva.dependency.graph.GraphTask;
import org.apache.maven.archiva.dependency.graph.PotentialCyclicEdgeProducer;
import org.apache.maven.archiva.dependency.graph.functors.UnresolvedGraphNodePredicate;
import org.apache.maven.archiva.model.VersionedReference;

public class ResolveGraphTask
implements GraphTask,
PotentialCyclicEdgeProducer {
    private DependencyGraphBuilder builder;
    private int resolvedCount = 0;

    private VersionedReference toVersionedReference(DependencyGraphNode node) {
        VersionedReference ref = new VersionedReference();
        ref.setGroupId(node.getArtifact().getGroupId());
        ref.setArtifactId(node.getArtifact().getArtifactId());
        ref.setVersion(node.getArtifact().getVersion());
        return ref;
    }

    public void executeTask(DependencyGraph graph) {
        this.resolvedCount = 0;
        VersionedReference rootRef = this.toVersionedReference(graph.getRootNode());
        if (!graph.getRootNode().isResolved()) {
            this.builder.resolveNode(graph, graph.getRootNode(), rootRef);
            ++this.resolvedCount;
        }
        boolean done = false;
        while (!done) {
            DependencyGraphNode node = this.findUnresolvedNode(graph);
            if (node == null) {
                done = true;
                break;
            }
            VersionedReference otherRef = this.toVersionedReference(node);
            this.builder.resolveNode(graph, node, otherRef);
            ++this.resolvedCount;
        }
    }

    private DependencyGraphNode findUnresolvedNode(DependencyGraph graph) {
        return (DependencyGraphNode)CollectionUtils.find((Collection)graph.getNodes(), (Predicate)UnresolvedGraphNodePredicate.getInstance());
    }

    public DependencyGraphBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(DependencyGraphBuilder graphBuilder) {
        this.builder = graphBuilder;
    }

    public String getTaskId() {
        return "resolve-graph";
    }

    public int getResolvedCount() {
        return this.resolvedCount;
    }
}

