/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.ConfigurationEvent;
import org.apache.archiva.configuration.ConfigurationListener;
import org.apache.archiva.configuration.ConfigurationRuntimeException;
import org.apache.archiva.configuration.IndeterminateConfigurationException;
import org.apache.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.archiva.configuration.RemoteRepositoryConfiguration;
import org.apache.archiva.configuration.RepositoryCheckPath;
import org.apache.archiva.configuration.V1RepositoryConfiguration;
import org.apache.archiva.configuration.functors.ProxyConnectorConfigurationOrderComparator;
import org.apache.archiva.configuration.io.registry.ConfigurationRegistryReader;
import org.apache.archiva.configuration.io.registry.ConfigurationRegistryWriter;
import org.apache.archiva.policies.DownloadErrorPolicy;
import org.apache.archiva.policies.Policy;
import org.apache.archiva.policies.PostDownloadPolicy;
import org.apache.archiva.policies.PreDownloadPolicy;
import org.apache.archiva.redback.components.evaluator.DefaultExpressionEvaluator;
import org.apache.archiva.redback.components.evaluator.EvaluatorException;
import org.apache.archiva.redback.components.evaluator.ExpressionSource;
import org.apache.archiva.redback.components.evaluator.sources.SystemPropertyExpressionSource;
import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.registry.RegistryException;
import org.apache.archiva.redback.components.registry.RegistryListener;
import org.apache.archiva.redback.components.registry.commons.CommonsConfigurationRegistry;
import org.apache.archiva.redback.components.springutils.ComponentContainer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="archivaConfiguration#default")
public class DefaultArchivaConfiguration
implements ArchivaConfiguration,
RegistryListener {
    private Logger log = LoggerFactory.getLogger(DefaultArchivaConfiguration.class);
    @Inject
    @Named(value="commons-configuration")
    private Registry registry;
    @Inject
    private ComponentContainer componentContainer;
    private Configuration configuration;
    private Map<String, PreDownloadPolicy> prePolicies;
    private Map<String, PostDownloadPolicy> postPolicies;
    private Map<String, DownloadErrorPolicy> downloadErrorPolicies;
    private String userConfigFilename = "${user.home}/.m2/archiva.xml";
    private String altConfigFilename = "${appserver.base}/conf/archiva.xml";
    private Set<ConfigurationListener> listeners = new HashSet<ConfigurationListener>();
    private Set<RegistryListener> registryListeners = new HashSet<RegistryListener>();
    private boolean isConfigurationDefaulted = false;
    private static final String KEY = "org.apache.archiva";
    private static final String KEY_DEFAULT_ONLY = "org.apache.archiva_default";

    @Override
    public Configuration getConfiguration() {
        return this.loadConfiguration();
    }

    private synchronized Configuration loadConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.load();
            this.configuration = this.unescapeExpressions(this.configuration);
            if (this.isConfigurationDefaulted) {
                this.configuration = this.checkRepositoryLocations(this.configuration);
            }
        }
        return this.configuration;
    }

    private boolean hasConfigVersionChanged(Configuration current, Registry defaultOnlyConfiguration) {
        return current == null || current.getVersion() == null || !current.getVersion().trim().equals(defaultOnlyConfiguration.getString("version", "").trim());
    }

    private Configuration load() {
        Registry subset = this.registry.getSubset(KEY);
        if (subset.getString("version") == null && subset.getSubset("repositoryScanning").isEmpty()) {
            subset = this.readDefaultConfiguration();
        }
        Configuration config = new ConfigurationRegistryReader().read(subset);
        config.getRepositoryGroups();
        config.getRepositoryGroupsAsMap();
        if (!config.getRepositories().isEmpty()) {
            for (V1RepositoryConfiguration r : config.getRepositories()) {
                r.setScanned(r.isIndexed());
                if (StringUtils.startsWith((String)r.getUrl(), (String)"file://")) {
                    r.setLocation(r.getUrl().substring(7));
                    config.addManagedRepository(r);
                    continue;
                }
                if (StringUtils.startsWith((String)r.getUrl(), (String)"file:")) {
                    r.setLocation(r.getUrl().substring(5));
                    config.addManagedRepository(r);
                    continue;
                }
                if (StringUtils.isEmpty((String)r.getUrl())) {
                    if (StringUtils.isEmpty((String)r.getLocation())) {
                        r.setLocation("file://${appserver.base}/repositories/" + r.getId());
                    }
                    config.addManagedRepository(r);
                    continue;
                }
                RemoteRepositoryConfiguration repo = new RemoteRepositoryConfiguration();
                repo.setId(r.getId());
                repo.setLayout(r.getLayout());
                repo.setName(r.getName());
                repo.setUrl(r.getUrl());
                config.addRemoteRepository(repo);
            }
            config.getRepositories().clear();
            this.registry.removeSubset("org.apache.archiva.repositories");
        }
        if (!CollectionUtils.isEmpty(config.getRemoteRepositories())) {
            List<RemoteRepositoryConfiguration> remoteRepos = config.getRemoteRepositories();
            for (RemoteRepositoryConfiguration repo : remoteRepos) {
                if (StringUtils.isBlank((String)repo.getUsername())) {
                    repo.setUsername(null);
                }
                if (!StringUtils.isBlank((String)repo.getPassword())) continue;
                repo.setPassword(null);
            }
        }
        if (!config.getProxyConnectors().isEmpty()) {
            ArrayList<ProxyConnectorConfiguration> proxyConnectorList = new ArrayList<ProxyConnectorConfiguration>(config.getProxyConnectors());
            config.getProxyConnectors().clear();
            for (ProxyConnectorConfiguration connector : proxyConnectorList) {
                boolean connectorValid = true;
                HashMap policies = new HashMap();
                policies.putAll(connector.getPolicies());
                connector.getPolicies().clear();
                for (Map.Entry entry : policies.entrySet()) {
                    String policyId = (String)entry.getKey();
                    String setting = (String)entry.getValue();
                    if ("releases".equals(policyId) || "snapshots".equals(policyId)) {
                        if ("ignored".equals(setting)) {
                            setting = "always";
                        } else if ("disabled".equals(setting)) {
                            setting = "never";
                        }
                    } else if ("cache-failures".equals(policyId)) {
                        if ("ignored".equals(setting)) {
                            setting = "no";
                        } else if ("cached".equals(setting)) {
                            setting = "yes";
                        }
                    } else if ("checksum".equals(policyId) && "ignored".equals(setting)) {
                        setting = "ignore";
                    }
                    if (this.policyExists(policyId)) {
                        Policy policy = this.findPolicy(policyId);
                        if (!policy.getOptions().contains(setting)) {
                            setting = policy.getDefaultOption();
                        }
                        connector.addPolicy(policyId, setting);
                        continue;
                    }
                    this.log.warn("Policy [{}] does not exist.", (Object)policyId);
                }
                if (!connectorValid) continue;
                config.addProxyConnector(connector);
            }
            Map<String, List<ProxyConnectorConfiguration>> proxyConnectorMap = config.getProxyConnectorAsMap();
            for (List<ProxyConnectorConfiguration> connectors : proxyConnectorMap.values()) {
                Collections.sort(connectors, ProxyConnectorConfigurationOrderComparator.getInstance());
                int order = 1;
                for (ProxyConnectorConfiguration proxyConnectorConfiguration : connectors) {
                    proxyConnectorConfiguration.setOrder(order++);
                }
            }
        }
        return config;
    }

    private void updateCheckPathDefaults(Configuration config, Registry defaultConfiguration) {
        List<RepositoryCheckPath> existingCheckPathList = config.getArchivaDefaultConfiguration().getDefaultCheckPaths();
        HashMap<String, RepositoryCheckPath> existingCheckPaths = new HashMap<String, RepositoryCheckPath>();
        HashMap<String, RepositoryCheckPath> newCheckPaths = new HashMap<String, RepositoryCheckPath>();
        for (RepositoryCheckPath path : config.getArchivaDefaultConfiguration().getDefaultCheckPaths()) {
            existingCheckPaths.put(path.getUrl(), path);
        }
        List defaultCheckPathsSubsets = defaultConfiguration.getSubsetList("archivaDefaultConfiguration.defaultCheckPaths.defaultCheckPath");
        Iterator i = defaultCheckPathsSubsets.iterator();
        while (i.hasNext()) {
            RepositoryCheckPath v = this.readRepositoryCheckPath((Registry)i.next());
            if (existingCheckPaths.containsKey(v.getUrl())) {
                existingCheckPathList.remove(existingCheckPaths.get(v.getUrl()));
            }
            existingCheckPathList.add(v);
            newCheckPaths.put(v.getUrl(), v);
        }
        for (RemoteRepositoryConfiguration remoteRepositoryConfiguration : config.getRemoteRepositories()) {
            String url = remoteRepositoryConfiguration.getUrl().toLowerCase();
            if (!newCheckPaths.containsKey(url)) continue;
            String currentPath = remoteRepositoryConfiguration.getCheckPath();
            String newPath = ((RepositoryCheckPath)newCheckPaths.get(url)).getPath();
            this.log.info("Updating connection check path for repository {}, from '{}' to '{}'.", new Object[]{remoteRepositoryConfiguration.getId(), currentPath, newPath});
            remoteRepositoryConfiguration.setCheckPath(newPath);
        }
    }

    private RepositoryCheckPath readRepositoryCheckPath(Registry registry) {
        RepositoryCheckPath value = new RepositoryCheckPath();
        String url = registry.getString("url", value.getUrl());
        value.setUrl(url);
        String path = registry.getString("path", value.getPath());
        value.setPath(path);
        return value;
    }

    private Policy findPolicy(String policyId) {
        if (MapUtils.isEmpty(this.prePolicies)) {
            this.log.error("No PreDownloadPolicies found!");
            return null;
        }
        if (MapUtils.isEmpty(this.postPolicies)) {
            this.log.error("No PostDownloadPolicies found!");
            return null;
        }
        Policy policy = (Policy)this.prePolicies.get(policyId);
        if (policy != null) {
            return policy;
        }
        policy = (Policy)this.postPolicies.get(policyId);
        if (policy != null) {
            return policy;
        }
        policy = (Policy)this.downloadErrorPolicies.get(policyId);
        if (policy != null) {
            return policy;
        }
        return null;
    }

    private boolean policyExists(String policyId) {
        if (MapUtils.isEmpty(this.prePolicies)) {
            this.log.error("No PreDownloadPolicies found!");
            return false;
        }
        if (MapUtils.isEmpty(this.postPolicies)) {
            this.log.error("No PostDownloadPolicies found!");
            return false;
        }
        return this.prePolicies.containsKey(policyId) || this.postPolicies.containsKey(policyId) || this.downloadErrorPolicies.containsKey(policyId);
    }

    private Registry readDefaultConfiguration() {
        this.registry.removeSubset(KEY);
        try {
            this.registry.addConfigurationFromResource("org/apache/archiva/configuration/default-archiva.xml", KEY);
            this.isConfigurationDefaulted = true;
        }
        catch (RegistryException e) {
            throw new ConfigurationRuntimeException("Fatal error: Unable to find the built-in default configuration and load it into the registry", e);
        }
        return this.registry.getSubset(KEY);
    }

    private Registry readDefaultOnlyConfiguration() {
        this.registry.removeSubset(KEY_DEFAULT_ONLY);
        try {
            this.registry.addConfigurationFromResource("org/apache/archiva/configuration/default-archiva.xml", KEY_DEFAULT_ONLY);
        }
        catch (RegistryException e) {
            throw new ConfigurationRuntimeException("Fatal error: Unable to find the built-in default configuration and load it into the registry", e);
        }
        return this.registry.getSubset(KEY_DEFAULT_ONLY);
    }

    @Override
    public synchronized void save(Configuration configuration) throws IndeterminateConfigurationException, RegistryException {
        Registry section = this.registry.getSection("org.apache.archiva.user");
        Registry baseSection = this.registry.getSection("org.apache.archiva.base");
        if (section == null) {
            section = baseSection;
            if (section == null) {
                section = this.createDefaultConfigurationFile();
            }
        } else if (baseSection != null) {
            Collection keys = baseSection.getKeys();
            boolean foundList = false;
            Iterator i = keys.iterator();
            while (i.hasNext() && !foundList) {
                String key = (String)i.next();
                if (!key.startsWith("repositories") && !key.startsWith("proxyConnectors") && !key.startsWith("networkProxies") && !key.startsWith("repositoryScanning") && !key.startsWith("remoteRepositories") && !key.startsWith("managedRepositories") && !key.startsWith("repositoryGroups")) continue;
                foundList = true;
            }
            if (foundList) {
                this.configuration = null;
                throw new IndeterminateConfigurationException("Configuration can not be saved when it is loaded from two sources");
            }
        }
        this.escapeCronExpressions(configuration);
        if (section != null) {
            if (configuration.getManagedRepositories().isEmpty()) {
                section.removeSubset("managedRepositories");
            }
            if (configuration.getRemoteRepositories().isEmpty()) {
                section.removeSubset("remoteRepositories");
            }
            if (configuration.getProxyConnectors().isEmpty()) {
                section.removeSubset("proxyConnectors");
            }
            if (configuration.getNetworkProxies().isEmpty()) {
                section.removeSubset("networkProxies");
            }
            if (configuration.getLegacyArtifactPaths().isEmpty()) {
                section.removeSubset("legacyArtifactPaths");
            }
            if (configuration.getRepositoryGroups().isEmpty()) {
                section.removeSubset("repositoryGroups");
            }
            if (configuration.getRepositoryScanning() != null) {
                if (configuration.getRepositoryScanning().getKnownContentConsumers().isEmpty()) {
                    section.removeSubset("repositoryScanning.knownContentConsumers");
                }
                if (configuration.getRepositoryScanning().getInvalidContentConsumers().isEmpty()) {
                    section.removeSubset("repositoryScanning.invalidContentConsumers");
                }
            }
            if (configuration.getArchivaRuntimeConfiguration() != null) {
                section.removeSubset("archivaRuntimeConfiguration.defaultCheckPaths");
            }
            new ConfigurationRegistryWriter().write(configuration, section);
            section.save();
        }
        this.configuration = this.unescapeExpressions(configuration);
        this.triggerEvent(1);
    }

    private void escapeCronExpressions(Configuration configuration) {
        for (ManagedRepositoryConfiguration c : configuration.getManagedRepositories()) {
            c.setRefreshCronExpression(this.escapeCronExpression(c.getRefreshCronExpression()));
        }
    }

    private Registry createDefaultConfigurationFile() throws RegistryException {
        String contents = "<configuration />";
        String fileLocation = this.userConfigFilename;
        if (!this.writeFile("user configuration", this.userConfigFilename, contents)) {
            fileLocation = this.altConfigFilename;
            if (!this.writeFile("alternative configuration", this.altConfigFilename, contents)) {
                throw new RegistryException("Unable to create configuration file in either user [" + this.userConfigFilename + "] or alternative [" + this.altConfigFilename + "] locations on disk, usually happens when not allowed to write to those locations.");
            }
        }
        contents = "<configuration><xml fileName=\"" + fileLocation + "\" config-forceCreate=\"true\" config-name=\"org.apache.archiva.user\"/>" + "</configuration>";
        ((CommonsConfigurationRegistry)this.registry).setProperties(contents);
        this.registry.initialize();
        for (RegistryListener regListener : this.registryListeners) {
            this.addRegistryChangeListener(regListener);
        }
        this.triggerEvent(1);
        Registry section = this.registry.getSection("org.apache.archiva.user");
        return section == null ? new CommonsConfigurationRegistry((org.apache.commons.configuration.Configuration)new BaseConfiguration()) : section;
    }

    private boolean writeFile(String filetype, String path, String contents) {
        File file = new File(path);
        try {
            if (file.getParentFile() != null && !file.getParentFile().isDirectory()) {
                return false;
            }
            FileUtils.writeStringToFile((File)file, (String)contents, (String)"UTF-8");
            return true;
        }
        catch (IOException e) {
            this.log.error("Unable to create " + filetype + " file: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void triggerEvent(int type) {
        ConfigurationEvent evt = new ConfigurationEvent(type);
        for (ConfigurationListener listener : this.listeners) {
            listener.configurationEvent(evt);
        }
    }

    @Override
    public void addListener(ConfigurationListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ConfigurationListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    @Override
    public void addChangeListener(RegistryListener listener) {
        this.addRegistryChangeListener(listener);
        this.registryListeners.add(listener);
    }

    private void addRegistryChangeListener(RegistryListener listener) {
        Registry section = this.registry.getSection("org.apache.archiva.user");
        if (section != null) {
            section.addChangeListener(listener);
        }
        if ((section = this.registry.getSection("org.apache.archiva.base")) != null) {
            section.addChangeListener(listener);
        }
    }

    @Override
    public void removeChangeListener(RegistryListener listener) {
        boolean removed = this.registryListeners.remove(listener);
        this.log.debug("RegistryListener: '{}' removed {}", (Object)listener, (Object)removed);
        Registry section = this.registry.getSection("org.apache.archiva.user");
        if (section != null) {
            section.removeChangeListener(listener);
        }
        if ((section = this.registry.getSection("org.apache.archiva.base")) != null) {
            section.removeChangeListener(listener);
        }
    }

    @PostConstruct
    public void initialize() {
        this.postPolicies = this.componentContainer.buildMapWithRole(PostDownloadPolicy.class);
        this.prePolicies = this.componentContainer.buildMapWithRole(PreDownloadPolicy.class);
        this.downloadErrorPolicies = this.componentContainer.buildMapWithRole(DownloadErrorPolicy.class);
        try {
            DefaultExpressionEvaluator expressionEvaluator = new DefaultExpressionEvaluator();
            expressionEvaluator.addExpressionSource((ExpressionSource)new SystemPropertyExpressionSource());
            String userConfigFileNameSysProps = System.getProperty("archiva.user.configFileName");
            this.userConfigFilename = StringUtils.isNotBlank((String)userConfigFileNameSysProps) ? userConfigFileNameSysProps : expressionEvaluator.expand(this.userConfigFilename);
            this.altConfigFilename = expressionEvaluator.expand(this.altConfigFilename);
            this.loadConfiguration();
            this.handleUpgradeConfiguration();
        }
        catch (IndeterminateConfigurationException | RegistryException e) {
            throw new RuntimeException("failed during upgrade from previous version" + e.getMessage(), e);
        }
        catch (EvaluatorException e) {
            throw new RuntimeException("Unable to evaluate expressions found in userConfigFilename or altConfigFilename.", e);
        }
        this.registry.addChangeListener((RegistryListener)this);
    }

    private void handleUpgradeConfiguration() throws RegistryException, IndeterminateConfigurationException {
        Registry defaultOnlyConfiguration;
        ArrayList<Object> knowContentConsumers;
        List<String> dbConsumers = Arrays.asList("update-db-artifact", "update-db-repository-metadata");
        List intersec = ListUtils.intersection(dbConsumers, this.configuration.getRepositoryScanning().getKnownContentConsumers());
        if (!intersec.isEmpty()) {
            knowContentConsumers = new ArrayList(this.configuration.getRepositoryScanning().getKnownContentConsumers().size());
            for (String knowContentConsumer : this.configuration.getRepositoryScanning().getKnownContentConsumers()) {
                if (dbConsumers.contains(knowContentConsumer)) continue;
                knowContentConsumers.add(knowContentConsumer);
            }
            this.configuration.getRepositoryScanning().setKnownContentConsumers(knowContentConsumers);
        }
        if (!this.configuration.getRepositoryScanning().getKnownContentConsumers().contains("create-archiva-metadata")) {
            knowContentConsumers = new ArrayList<String>(this.configuration.getRepositoryScanning().getKnownContentConsumers());
            knowContentConsumers.add("create-archiva-metadata");
            this.configuration.getRepositoryScanning().setKnownContentConsumers(knowContentConsumers);
        }
        if (!this.configuration.getRepositoryScanning().getKnownContentConsumers().contains("duplicate-artifacts")) {
            knowContentConsumers = new ArrayList<String>(this.configuration.getRepositoryScanning().getKnownContentConsumers());
            knowContentConsumers.add("duplicate-artifacts");
            this.configuration.getRepositoryScanning().setKnownContentConsumers(knowContentConsumers);
        }
        if (this.hasConfigVersionChanged(this.configuration, defaultOnlyConfiguration = this.readDefaultOnlyConfiguration())) {
            this.updateCheckPathDefaults(this.configuration, defaultOnlyConfiguration);
            String newVersion = defaultOnlyConfiguration.getString("version");
            if (newVersion == null) {
                throw new IndeterminateConfigurationException("The default configuration has no version information!");
            }
            this.configuration.setVersion(newVersion);
            try {
                this.save(this.configuration);
            }
            catch (IndeterminateConfigurationException e) {
                this.log.error("Error occured during configuration update to new version: {}", (Object)e.getMessage());
            }
            catch (RegistryException e) {
                this.log.error("Error occured during configuration update to new version: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void reload() {
        this.configuration = null;
        try {
            this.registry.initialize();
        }
        catch (RegistryException e) {
            throw new ConfigurationRuntimeException(e.getMessage(), e);
        }
        this.initialize();
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    public synchronized void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        this.configuration = null;
    }

    private String removeExpressions(String directory) {
        String value = StringUtils.replace((String)directory, (String)"${appserver.base}", (String)this.registry.getString("appserver.base", "${appserver.base}"));
        value = StringUtils.replace((String)value, (String)"${appserver.home}", (String)this.registry.getString("appserver.home", "${appserver.home}"));
        return value;
    }

    private String unescapeCronExpression(String cronExpression) {
        return StringUtils.replace((String)cronExpression, (String)"\\,", (String)",");
    }

    private String escapeCronExpression(String cronExpression) {
        return StringUtils.replace((String)cronExpression, (String)",", (String)"\\,");
    }

    private Configuration unescapeExpressions(Configuration config) {
        for (ManagedRepositoryConfiguration c : config.getManagedRepositories()) {
            c.setLocation(this.removeExpressions(c.getLocation()));
            c.setRefreshCronExpression(this.unescapeCronExpression(c.getRefreshCronExpression()));
        }
        return config;
    }

    private Configuration checkRepositoryLocations(Configuration config) {
        for (ManagedRepositoryConfiguration repo : config.getManagedRepositories()) {
            String repoPath = repo.getLocation();
            File repoLocation = new File(repoPath);
            if (!repoLocation.exists() || !repoLocation.isDirectory() || repoPath.endsWith("data/repositories/" + repo.getId())) continue;
            repo.setLocation(repoPath + "/data/repositories/" + repo.getId());
        }
        return config;
    }

    public String getUserConfigFilename() {
        return this.userConfigFilename;
    }

    public String getAltConfigFilename() {
        return this.altConfigFilename;
    }

    @Override
    public boolean isDefaulted() {
        return this.isConfigurationDefaulted;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setUserConfigFilename(String userConfigFilename) {
        this.userConfigFilename = userConfigFilename;
    }

    public void setAltConfigFilename(String altConfigFilename) {
        this.altConfigFilename = altConfigFilename;
    }
}

