/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.configuration.io.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.archiva.configuration.AbstractRepositoryConfiguration;
import org.apache.archiva.configuration.AbstractRepositoryConnectorConfiguration;
import org.apache.archiva.configuration.ArchivaRuntimeConfiguration;
import org.apache.archiva.configuration.CacheConfiguration;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.FileType;
import org.apache.archiva.configuration.LdapConfiguration;
import org.apache.archiva.configuration.LdapGroupMapping;
import org.apache.archiva.configuration.LegacyArtifactPath;
import org.apache.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.archiva.configuration.NetworkConfiguration;
import org.apache.archiva.configuration.NetworkProxyConfiguration;
import org.apache.archiva.configuration.OrganisationInformation;
import org.apache.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.archiva.configuration.ProxyConnectorRuleConfiguration;
import org.apache.archiva.configuration.RedbackRuntimeConfiguration;
import org.apache.archiva.configuration.RemoteRepositoryConfiguration;
import org.apache.archiva.configuration.RepositoryGroupConfiguration;
import org.apache.archiva.configuration.RepositoryScanningConfiguration;
import org.apache.archiva.configuration.SyncConnectorConfiguration;
import org.apache.archiva.configuration.UserInterfaceOptions;
import org.apache.archiva.configuration.V1RepositoryConfiguration;
import org.apache.archiva.configuration.WebappConfiguration;
import org.apache.archiva.redback.components.registry.Registry;

public class ConfigurationRegistryReader {
    public Configuration read(Registry registry) {
        return this.readConfiguration("", registry);
    }

    private Configuration readConfiguration(String prefix, Registry registry) {
        Configuration value = new Configuration();
        List versionList = registry.getList(prefix + "version");
        String version = value.getVersion();
        if (versionList != null && !versionList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = versionList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)versionList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            version = sb.toString();
        }
        value.setVersion(version);
        ArrayList<V1RepositoryConfiguration> repositories = new ArrayList<V1RepositoryConfiguration>();
        List repositoriesSubsets = registry.getSubsetList(prefix + "repositories.repository");
        Iterator i = repositoriesSubsets.iterator();
        while (i.hasNext()) {
            V1RepositoryConfiguration v = this.readV1RepositoryConfiguration("", (Registry)i.next());
            repositories.add(v);
        }
        value.setRepositories(repositories);
        ArrayList<RepositoryGroupConfiguration> repositoryGroups = new ArrayList<RepositoryGroupConfiguration>();
        List repositoryGroupsSubsets = registry.getSubsetList(prefix + "repositoryGroups.repositoryGroup");
        Iterator i2 = repositoryGroupsSubsets.iterator();
        while (i2.hasNext()) {
            RepositoryGroupConfiguration v = this.readRepositoryGroupConfiguration("", (Registry)i2.next());
            repositoryGroups.add(v);
        }
        value.setRepositoryGroups(repositoryGroups);
        ArrayList<ManagedRepositoryConfiguration> managedRepositories = new ArrayList<ManagedRepositoryConfiguration>();
        List managedRepositoriesSubsets = registry.getSubsetList(prefix + "managedRepositories.managedRepository");
        Iterator i3 = managedRepositoriesSubsets.iterator();
        while (i3.hasNext()) {
            ManagedRepositoryConfiguration v = this.readManagedRepositoryConfiguration("", (Registry)i3.next());
            managedRepositories.add(v);
        }
        value.setManagedRepositories(managedRepositories);
        ArrayList<RemoteRepositoryConfiguration> remoteRepositories = new ArrayList<RemoteRepositoryConfiguration>();
        List remoteRepositoriesSubsets = registry.getSubsetList(prefix + "remoteRepositories.remoteRepository");
        Iterator i4 = remoteRepositoriesSubsets.iterator();
        while (i4.hasNext()) {
            RemoteRepositoryConfiguration v = this.readRemoteRepositoryConfiguration("", (Registry)i4.next());
            remoteRepositories.add(v);
        }
        value.setRemoteRepositories(remoteRepositories);
        ArrayList<ProxyConnectorConfiguration> proxyConnectors = new ArrayList<ProxyConnectorConfiguration>();
        List proxyConnectorsSubsets = registry.getSubsetList(prefix + "proxyConnectors.proxyConnector");
        Iterator i5 = proxyConnectorsSubsets.iterator();
        while (i5.hasNext()) {
            ProxyConnectorConfiguration v = this.readProxyConnectorConfiguration("", (Registry)i5.next());
            proxyConnectors.add(v);
        }
        value.setProxyConnectors(proxyConnectors);
        ArrayList<NetworkProxyConfiguration> networkProxies = new ArrayList<NetworkProxyConfiguration>();
        List networkProxiesSubsets = registry.getSubsetList(prefix + "networkProxies.networkProxy");
        Iterator i6 = networkProxiesSubsets.iterator();
        while (i6.hasNext()) {
            NetworkProxyConfiguration v = this.readNetworkProxyConfiguration("", (Registry)i6.next());
            networkProxies.add(v);
        }
        value.setNetworkProxies(networkProxies);
        ArrayList<LegacyArtifactPath> legacyArtifactPaths = new ArrayList<LegacyArtifactPath>();
        List legacyArtifactPathsSubsets = registry.getSubsetList(prefix + "legacyArtifactPaths.legacyArtifactPath");
        Iterator i7 = legacyArtifactPathsSubsets.iterator();
        while (i7.hasNext()) {
            LegacyArtifactPath v = this.readLegacyArtifactPath("", (Registry)i7.next());
            legacyArtifactPaths.add(v);
        }
        value.setLegacyArtifactPaths(legacyArtifactPaths);
        RepositoryScanningConfiguration repositoryScanning = this.readRepositoryScanningConfiguration(prefix + "repositoryScanning.", registry);
        value.setRepositoryScanning(repositoryScanning);
        WebappConfiguration webapp = this.readWebappConfiguration(prefix + "webapp.", registry);
        value.setWebapp(webapp);
        OrganisationInformation organisationInfo = this.readOrganisationInformation(prefix + "organisationInfo.", registry);
        value.setOrganisationInfo(organisationInfo);
        NetworkConfiguration networkConfiguration = this.readNetworkConfiguration(prefix + "networkConfiguration.", registry);
        value.setNetworkConfiguration(networkConfiguration);
        RedbackRuntimeConfiguration redbackRuntimeConfiguration = this.readRedbackRuntimeConfiguration(prefix + "redbackRuntimeConfiguration.", registry);
        value.setRedbackRuntimeConfiguration(redbackRuntimeConfiguration);
        ArchivaRuntimeConfiguration archivaRuntimeConfiguration = this.readArchivaRuntimeConfiguration(prefix + "archivaRuntimeConfiguration.", registry);
        value.setArchivaRuntimeConfiguration(archivaRuntimeConfiguration);
        ArrayList<ProxyConnectorRuleConfiguration> proxyConnectorRuleConfigurations = new ArrayList<ProxyConnectorRuleConfiguration>();
        List proxyConnectorRuleConfigurationsSubsets = registry.getSubsetList(prefix + "proxyConnectorRuleConfigurations.proxyConnectorRuleConfiguration");
        Iterator i8 = proxyConnectorRuleConfigurationsSubsets.iterator();
        while (i8.hasNext()) {
            ProxyConnectorRuleConfiguration v = this.readProxyConnectorRuleConfiguration("", (Registry)i8.next());
            proxyConnectorRuleConfigurations.add(v);
        }
        value.setProxyConnectorRuleConfigurations(proxyConnectorRuleConfigurations);
        return value;
    }

    private AbstractRepositoryConfiguration readAbstractRepositoryConfiguration(String prefix, Registry registry) {
        AbstractRepositoryConfiguration value = new AbstractRepositoryConfiguration();
        List idList = registry.getList(prefix + "id");
        String id = value.getId();
        if (idList != null && !idList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = idList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)idList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            id = sb.toString();
        }
        value.setId(id);
        List nameList = registry.getList(prefix + "name");
        String name = value.getName();
        if (nameList != null && !nameList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = nameList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)nameList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            name = sb.toString();
        }
        value.setName(name);
        List layoutList = registry.getList(prefix + "layout");
        String layout = value.getLayout();
        if (layoutList != null && !layoutList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = layoutList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)layoutList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            layout = sb.toString();
        }
        value.setLayout(layout);
        List indexDirList = registry.getList(prefix + "indexDir");
        String indexDir = value.getIndexDir();
        if (indexDirList != null && !indexDirList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = indexDirList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)indexDirList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            indexDir = sb.toString();
        }
        value.setIndexDir(indexDir);
        List descriptionList = registry.getList(prefix + "description");
        String description = value.getDescription();
        if (descriptionList != null && !descriptionList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = descriptionList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)descriptionList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            description = sb.toString();
        }
        value.setDescription(description);
        return value;
    }

    private RemoteRepositoryConfiguration readRemoteRepositoryConfiguration(String prefix, Registry registry) {
        RemoteRepositoryConfiguration value = new RemoteRepositoryConfiguration();
        List urlList = registry.getList(prefix + "url");
        String url = value.getUrl();
        if (urlList != null && !urlList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = urlList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)urlList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            url = sb.toString();
        }
        value.setUrl(url);
        List usernameList = registry.getList(prefix + "username");
        String username = value.getUsername();
        if (usernameList != null && !usernameList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = usernameList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)usernameList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            username = sb.toString();
        }
        value.setUsername(username);
        List passwordList = registry.getList(prefix + "password");
        String password = value.getPassword();
        if (passwordList != null && !passwordList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = passwordList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)passwordList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            password = sb.toString();
        }
        value.setPassword(password);
        int timeout = registry.getInt(prefix + "timeout", value.getTimeout());
        value.setTimeout(timeout);
        List refreshCronExpressionList = registry.getList(prefix + "refreshCronExpression");
        String refreshCronExpression = value.getRefreshCronExpression();
        if (refreshCronExpressionList != null && !refreshCronExpressionList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = refreshCronExpressionList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)refreshCronExpressionList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            refreshCronExpression = sb.toString();
        }
        value.setRefreshCronExpression(refreshCronExpression);
        boolean downloadRemoteIndex = registry.getBoolean(prefix + "downloadRemoteIndex", value.isDownloadRemoteIndex());
        value.setDownloadRemoteIndex(downloadRemoteIndex);
        List remoteIndexUrlList = registry.getList(prefix + "remoteIndexUrl");
        String remoteIndexUrl = value.getRemoteIndexUrl();
        if (remoteIndexUrlList != null && !remoteIndexUrlList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = remoteIndexUrlList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)remoteIndexUrlList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            remoteIndexUrl = sb.toString();
        }
        value.setRemoteIndexUrl(remoteIndexUrl);
        List remoteDownloadNetworkProxyIdList = registry.getList(prefix + "remoteDownloadNetworkProxyId");
        String remoteDownloadNetworkProxyId = value.getRemoteDownloadNetworkProxyId();
        if (remoteDownloadNetworkProxyIdList != null && !remoteDownloadNetworkProxyIdList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = remoteDownloadNetworkProxyIdList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)remoteDownloadNetworkProxyIdList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            remoteDownloadNetworkProxyId = sb.toString();
        }
        value.setRemoteDownloadNetworkProxyId(remoteDownloadNetworkProxyId);
        int remoteDownloadTimeout = registry.getInt(prefix + "remoteDownloadTimeout", value.getRemoteDownloadTimeout());
        value.setRemoteDownloadTimeout(remoteDownloadTimeout);
        boolean downloadRemoteIndexOnStartup = registry.getBoolean(prefix + "downloadRemoteIndexOnStartup", value.isDownloadRemoteIndexOnStartup());
        value.setDownloadRemoteIndexOnStartup(downloadRemoteIndexOnStartup);
        Properties extraParameters = registry.getProperties(prefix + "extraParameters");
        value.setExtraParameters(extraParameters);
        Properties extraHeaders = registry.getProperties(prefix + "extraHeaders");
        value.setExtraHeaders(extraHeaders);
        List idList = registry.getList(prefix + "id");
        String id = value.getId();
        if (idList != null && !idList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = idList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)idList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            id = sb.toString();
        }
        value.setId(id);
        List nameList = registry.getList(prefix + "name");
        String name = value.getName();
        if (nameList != null && !nameList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = nameList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)nameList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            name = sb.toString();
        }
        value.setName(name);
        List layoutList = registry.getList(prefix + "layout");
        String layout = value.getLayout();
        if (layoutList != null && !layoutList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = layoutList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)layoutList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            layout = sb.toString();
        }
        value.setLayout(layout);
        List indexDirList = registry.getList(prefix + "indexDir");
        String indexDir = value.getIndexDir();
        if (indexDirList != null && !indexDirList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = indexDirList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)indexDirList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            indexDir = sb.toString();
        }
        value.setIndexDir(indexDir);
        List descriptionList = registry.getList(prefix + "description");
        String description = value.getDescription();
        if (descriptionList != null && !descriptionList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = descriptionList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)descriptionList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            description = sb.toString();
        }
        value.setDescription(description);
        return value;
    }

    private ManagedRepositoryConfiguration readManagedRepositoryConfiguration(String prefix, Registry registry) {
        ManagedRepositoryConfiguration value = new ManagedRepositoryConfiguration();
        List locationList = registry.getList(prefix + "location");
        String location = value.getLocation();
        if (locationList != null && !locationList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = locationList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)locationList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            location = sb.toString();
        }
        value.setLocation(location);
        boolean releases = registry.getBoolean(prefix + "releases", value.isReleases());
        value.setReleases(releases);
        boolean blockRedeployments = registry.getBoolean(prefix + "blockRedeployments", value.isBlockRedeployments());
        value.setBlockRedeployments(blockRedeployments);
        boolean snapshots = registry.getBoolean(prefix + "snapshots", value.isSnapshots());
        value.setSnapshots(snapshots);
        boolean scanned = registry.getBoolean(prefix + "scanned", value.isScanned());
        value.setScanned(scanned);
        List refreshCronExpressionList = registry.getList(prefix + "refreshCronExpression");
        String refreshCronExpression = value.getRefreshCronExpression();
        if (refreshCronExpressionList != null && !refreshCronExpressionList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = refreshCronExpressionList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)refreshCronExpressionList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            refreshCronExpression = sb.toString();
        }
        value.setRefreshCronExpression(refreshCronExpression);
        int retentionCount = registry.getInt(prefix + "retentionCount", value.getRetentionCount());
        value.setRetentionCount(retentionCount);
        int daysOlder = registry.getInt(prefix + "daysOlder", value.getDaysOlder());
        value.setDaysOlder(daysOlder);
        boolean deleteReleasedSnapshots = registry.getBoolean(prefix + "deleteReleasedSnapshots", value.isDeleteReleasedSnapshots());
        value.setDeleteReleasedSnapshots(deleteReleasedSnapshots);
        boolean skipPackedIndexCreation = registry.getBoolean(prefix + "skipPackedIndexCreation", value.isSkipPackedIndexCreation());
        value.setSkipPackedIndexCreation(skipPackedIndexCreation);
        boolean stageRepoNeeded = registry.getBoolean(prefix + "stageRepoNeeded", value.isStageRepoNeeded());
        value.setStageRepoNeeded(stageRepoNeeded);
        List idList = registry.getList(prefix + "id");
        String id = value.getId();
        if (idList != null && !idList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = idList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)idList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            id = sb.toString();
        }
        value.setId(id);
        List nameList = registry.getList(prefix + "name");
        String name = value.getName();
        if (nameList != null && !nameList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = nameList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)nameList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            name = sb.toString();
        }
        value.setName(name);
        List layoutList = registry.getList(prefix + "layout");
        String layout = value.getLayout();
        if (layoutList != null && !layoutList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = layoutList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)layoutList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            layout = sb.toString();
        }
        value.setLayout(layout);
        List indexDirList = registry.getList(prefix + "indexDir");
        String indexDir = value.getIndexDir();
        if (indexDirList != null && !indexDirList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = indexDirList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)indexDirList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            indexDir = sb.toString();
        }
        value.setIndexDir(indexDir);
        List descriptionList = registry.getList(prefix + "description");
        String description = value.getDescription();
        if (descriptionList != null && !descriptionList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = descriptionList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)descriptionList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            description = sb.toString();
        }
        value.setDescription(description);
        return value;
    }

    private V1RepositoryConfiguration readV1RepositoryConfiguration(String prefix, Registry registry) {
        V1RepositoryConfiguration value = new V1RepositoryConfiguration();
        List urlList = registry.getList(prefix + "url");
        String url = value.getUrl();
        if (urlList != null && !urlList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = urlList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)urlList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            url = sb.toString();
        }
        value.setUrl(url);
        boolean indexed = registry.getBoolean(prefix + "indexed", value.isIndexed());
        value.setIndexed(indexed);
        List locationList = registry.getList(prefix + "location");
        String location = value.getLocation();
        if (locationList != null && !locationList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = locationList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)locationList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            location = sb.toString();
        }
        value.setLocation(location);
        boolean releases = registry.getBoolean(prefix + "releases", value.isReleases());
        value.setReleases(releases);
        boolean blockRedeployments = registry.getBoolean(prefix + "blockRedeployments", value.isBlockRedeployments());
        value.setBlockRedeployments(blockRedeployments);
        boolean snapshots = registry.getBoolean(prefix + "snapshots", value.isSnapshots());
        value.setSnapshots(snapshots);
        boolean scanned = registry.getBoolean(prefix + "scanned", value.isScanned());
        value.setScanned(scanned);
        List refreshCronExpressionList = registry.getList(prefix + "refreshCronExpression");
        String refreshCronExpression = value.getRefreshCronExpression();
        if (refreshCronExpressionList != null && !refreshCronExpressionList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = refreshCronExpressionList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)refreshCronExpressionList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            refreshCronExpression = sb.toString();
        }
        value.setRefreshCronExpression(refreshCronExpression);
        int retentionCount = registry.getInt(prefix + "retentionCount", value.getRetentionCount());
        value.setRetentionCount(retentionCount);
        int daysOlder = registry.getInt(prefix + "daysOlder", value.getDaysOlder());
        value.setDaysOlder(daysOlder);
        boolean deleteReleasedSnapshots = registry.getBoolean(prefix + "deleteReleasedSnapshots", value.isDeleteReleasedSnapshots());
        value.setDeleteReleasedSnapshots(deleteReleasedSnapshots);
        boolean skipPackedIndexCreation = registry.getBoolean(prefix + "skipPackedIndexCreation", value.isSkipPackedIndexCreation());
        value.setSkipPackedIndexCreation(skipPackedIndexCreation);
        boolean stageRepoNeeded = registry.getBoolean(prefix + "stageRepoNeeded", value.isStageRepoNeeded());
        value.setStageRepoNeeded(stageRepoNeeded);
        List idList = registry.getList(prefix + "id");
        String id = value.getId();
        if (idList != null && !idList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = idList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)idList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            id = sb.toString();
        }
        value.setId(id);
        List nameList = registry.getList(prefix + "name");
        String name = value.getName();
        if (nameList != null && !nameList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = nameList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)nameList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            name = sb.toString();
        }
        value.setName(name);
        List layoutList = registry.getList(prefix + "layout");
        String layout = value.getLayout();
        if (layoutList != null && !layoutList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = layoutList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)layoutList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            layout = sb.toString();
        }
        value.setLayout(layout);
        List indexDirList = registry.getList(prefix + "indexDir");
        String indexDir = value.getIndexDir();
        if (indexDirList != null && !indexDirList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = indexDirList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)indexDirList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            indexDir = sb.toString();
        }
        value.setIndexDir(indexDir);
        List descriptionList = registry.getList(prefix + "description");
        String description = value.getDescription();
        if (descriptionList != null && !descriptionList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = descriptionList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)descriptionList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            description = sb.toString();
        }
        value.setDescription(description);
        return value;
    }

    private LegacyArtifactPath readLegacyArtifactPath(String prefix, Registry registry) {
        LegacyArtifactPath value = new LegacyArtifactPath();
        List pathList = registry.getList(prefix + "path");
        String path = value.getPath();
        if (pathList != null && !pathList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = pathList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)pathList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            path = sb.toString();
        }
        value.setPath(path);
        List artifactList = registry.getList(prefix + "artifact");
        String artifact = value.getArtifact();
        if (artifactList != null && !artifactList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = artifactList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)artifactList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            artifact = sb.toString();
        }
        value.setArtifact(artifact);
        return value;
    }

    private RepositoryGroupConfiguration readRepositoryGroupConfiguration(String prefix, Registry registry) {
        RepositoryGroupConfiguration value = new RepositoryGroupConfiguration();
        List idList = registry.getList(prefix + "id");
        String id = value.getId();
        if (idList != null && !idList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = idList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)idList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            id = sb.toString();
        }
        value.setId(id);
        List mergedIndexPathList = registry.getList(prefix + "mergedIndexPath");
        String mergedIndexPath = value.getMergedIndexPath();
        if (mergedIndexPathList != null && !mergedIndexPathList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = mergedIndexPathList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)mergedIndexPathList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            mergedIndexPath = sb.toString();
        }
        value.setMergedIndexPath(mergedIndexPath);
        int mergedIndexTtl = registry.getInt(prefix + "mergedIndexTtl", value.getMergedIndexTtl());
        value.setMergedIndexTtl(mergedIndexTtl);
        ArrayList<String> repositories = new ArrayList<String>();
        repositories.addAll(registry.getList(prefix + "repositories.repository"));
        value.setRepositories(repositories);
        return value;
    }

    private AbstractRepositoryConnectorConfiguration readAbstractRepositoryConnectorConfiguration(String prefix, Registry registry) {
        AbstractRepositoryConnectorConfiguration value = new AbstractRepositoryConnectorConfiguration();
        List sourceRepoIdList = registry.getList(prefix + "sourceRepoId");
        String sourceRepoId = value.getSourceRepoId();
        if (sourceRepoIdList != null && !sourceRepoIdList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = sourceRepoIdList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)sourceRepoIdList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            sourceRepoId = sb.toString();
        }
        value.setSourceRepoId(sourceRepoId);
        List targetRepoIdList = registry.getList(prefix + "targetRepoId");
        String targetRepoId = value.getTargetRepoId();
        if (targetRepoIdList != null && !targetRepoIdList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = targetRepoIdList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)targetRepoIdList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            targetRepoId = sb.toString();
        }
        value.setTargetRepoId(targetRepoId);
        List proxyIdList = registry.getList(prefix + "proxyId");
        String proxyId = value.getProxyId();
        if (proxyIdList != null && !proxyIdList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = proxyIdList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)proxyIdList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            proxyId = sb.toString();
        }
        value.setProxyId(proxyId);
        ArrayList<String> blackListPatterns = new ArrayList<String>();
        blackListPatterns.addAll(registry.getList(prefix + "blackListPatterns.blackListPattern"));
        value.setBlackListPatterns(blackListPatterns);
        ArrayList<String> whiteListPatterns = new ArrayList<String>();
        whiteListPatterns.addAll(registry.getList(prefix + "whiteListPatterns.whiteListPattern"));
        value.setWhiteListPatterns(whiteListPatterns);
        Properties policies = registry.getProperties(prefix + "policies");
        value.setPolicies(policies);
        Properties properties = registry.getProperties(prefix + "properties");
        value.setProperties(properties);
        boolean disabled = registry.getBoolean(prefix + "disabled", value.isDisabled());
        value.setDisabled(disabled);
        return value;
    }

    private ProxyConnectorRuleConfiguration readProxyConnectorRuleConfiguration(String prefix, Registry registry) {
        ProxyConnectorRuleConfiguration value = new ProxyConnectorRuleConfiguration();
        List ruleTypeList = registry.getList(prefix + "ruleType");
        String ruleType = value.getRuleType();
        if (ruleTypeList != null && !ruleTypeList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = ruleTypeList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)ruleTypeList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            ruleType = sb.toString();
        }
        value.setRuleType(ruleType);
        List patternList = registry.getList(prefix + "pattern");
        String pattern = value.getPattern();
        if (patternList != null && !patternList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = patternList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)patternList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            pattern = sb.toString();
        }
        value.setPattern(pattern);
        ArrayList<ProxyConnectorConfiguration> proxyConnectors = new ArrayList<ProxyConnectorConfiguration>();
        List proxyConnectorsSubsets = registry.getSubsetList(prefix + "proxyConnectors.proxyConnector");
        Iterator i = proxyConnectorsSubsets.iterator();
        while (i.hasNext()) {
            ProxyConnectorConfiguration v = this.readProxyConnectorConfiguration("", (Registry)i.next());
            proxyConnectors.add(v);
        }
        value.setProxyConnectors(proxyConnectors);
        return value;
    }

    private ProxyConnectorConfiguration readProxyConnectorConfiguration(String prefix, Registry registry) {
        ProxyConnectorConfiguration value = new ProxyConnectorConfiguration();
        int order = registry.getInt(prefix + "order", value.getOrder());
        value.setOrder(order);
        List sourceRepoIdList = registry.getList(prefix + "sourceRepoId");
        String sourceRepoId = value.getSourceRepoId();
        if (sourceRepoIdList != null && !sourceRepoIdList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = sourceRepoIdList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)sourceRepoIdList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            sourceRepoId = sb.toString();
        }
        value.setSourceRepoId(sourceRepoId);
        List targetRepoIdList = registry.getList(prefix + "targetRepoId");
        String targetRepoId = value.getTargetRepoId();
        if (targetRepoIdList != null && !targetRepoIdList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = targetRepoIdList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)targetRepoIdList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            targetRepoId = sb.toString();
        }
        value.setTargetRepoId(targetRepoId);
        List proxyIdList = registry.getList(prefix + "proxyId");
        String proxyId = value.getProxyId();
        if (proxyIdList != null && !proxyIdList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = proxyIdList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)proxyIdList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            proxyId = sb.toString();
        }
        value.setProxyId(proxyId);
        ArrayList<String> blackListPatterns = new ArrayList<String>();
        blackListPatterns.addAll(registry.getList(prefix + "blackListPatterns.blackListPattern"));
        value.setBlackListPatterns(blackListPatterns);
        ArrayList<String> whiteListPatterns = new ArrayList<String>();
        whiteListPatterns.addAll(registry.getList(prefix + "whiteListPatterns.whiteListPattern"));
        value.setWhiteListPatterns(whiteListPatterns);
        Properties policies = registry.getProperties(prefix + "policies");
        value.setPolicies(policies);
        Properties properties = registry.getProperties(prefix + "properties");
        value.setProperties(properties);
        boolean disabled = registry.getBoolean(prefix + "disabled", value.isDisabled());
        value.setDisabled(disabled);
        return value;
    }

    private SyncConnectorConfiguration readSyncConnectorConfiguration(String prefix, Registry registry) {
        SyncConnectorConfiguration value = new SyncConnectorConfiguration();
        List cronExpressionList = registry.getList(prefix + "cronExpression");
        String cronExpression = value.getCronExpression();
        if (cronExpressionList != null && !cronExpressionList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = cronExpressionList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)cronExpressionList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            cronExpression = sb.toString();
        }
        value.setCronExpression(cronExpression);
        List methodList = registry.getList(prefix + "method");
        String method = value.getMethod();
        if (methodList != null && !methodList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = methodList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)methodList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            method = sb.toString();
        }
        value.setMethod(method);
        List sourceRepoIdList = registry.getList(prefix + "sourceRepoId");
        String sourceRepoId = value.getSourceRepoId();
        if (sourceRepoIdList != null && !sourceRepoIdList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = sourceRepoIdList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)sourceRepoIdList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            sourceRepoId = sb.toString();
        }
        value.setSourceRepoId(sourceRepoId);
        List targetRepoIdList = registry.getList(prefix + "targetRepoId");
        String targetRepoId = value.getTargetRepoId();
        if (targetRepoIdList != null && !targetRepoIdList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = targetRepoIdList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)targetRepoIdList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            targetRepoId = sb.toString();
        }
        value.setTargetRepoId(targetRepoId);
        List proxyIdList = registry.getList(prefix + "proxyId");
        String proxyId = value.getProxyId();
        if (proxyIdList != null && !proxyIdList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = proxyIdList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)proxyIdList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            proxyId = sb.toString();
        }
        value.setProxyId(proxyId);
        ArrayList<String> blackListPatterns = new ArrayList<String>();
        blackListPatterns.addAll(registry.getList(prefix + "blackListPatterns.blackListPattern"));
        value.setBlackListPatterns(blackListPatterns);
        ArrayList<String> whiteListPatterns = new ArrayList<String>();
        whiteListPatterns.addAll(registry.getList(prefix + "whiteListPatterns.whiteListPattern"));
        value.setWhiteListPatterns(whiteListPatterns);
        Properties policies = registry.getProperties(prefix + "policies");
        value.setPolicies(policies);
        Properties properties = registry.getProperties(prefix + "properties");
        value.setProperties(properties);
        boolean disabled = registry.getBoolean(prefix + "disabled", value.isDisabled());
        value.setDisabled(disabled);
        return value;
    }

    private NetworkProxyConfiguration readNetworkProxyConfiguration(String prefix, Registry registry) {
        NetworkProxyConfiguration value = new NetworkProxyConfiguration();
        List idList = registry.getList(prefix + "id");
        String id = value.getId();
        if (idList != null && !idList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = idList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)idList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            id = sb.toString();
        }
        value.setId(id);
        List protocolList = registry.getList(prefix + "protocol");
        String protocol = value.getProtocol();
        if (protocolList != null && !protocolList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = protocolList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)protocolList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            protocol = sb.toString();
        }
        value.setProtocol(protocol);
        List hostList = registry.getList(prefix + "host");
        String host = value.getHost();
        if (hostList != null && !hostList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = hostList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)hostList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            host = sb.toString();
        }
        value.setHost(host);
        int port = registry.getInt(prefix + "port", value.getPort());
        value.setPort(port);
        List usernameList = registry.getList(prefix + "username");
        String username = value.getUsername();
        if (usernameList != null && !usernameList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = usernameList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)usernameList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            username = sb.toString();
        }
        value.setUsername(username);
        List passwordList = registry.getList(prefix + "password");
        String password = value.getPassword();
        if (passwordList != null && !passwordList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = passwordList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)passwordList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            password = sb.toString();
        }
        value.setPassword(password);
        boolean useNtlm = registry.getBoolean(prefix + "useNtlm", value.isUseNtlm());
        value.setUseNtlm(useNtlm);
        return value;
    }

    private RepositoryScanningConfiguration readRepositoryScanningConfiguration(String prefix, Registry registry) {
        RepositoryScanningConfiguration value = new RepositoryScanningConfiguration();
        ArrayList<FileType> fileTypes = new ArrayList<FileType>();
        List fileTypesSubsets = registry.getSubsetList(prefix + "fileTypes.fileType");
        Iterator i = fileTypesSubsets.iterator();
        while (i.hasNext()) {
            FileType v = this.readFileType("", (Registry)i.next());
            fileTypes.add(v);
        }
        value.setFileTypes(fileTypes);
        ArrayList<String> knownContentConsumers = new ArrayList<String>();
        knownContentConsumers.addAll(registry.getList(prefix + "knownContentConsumers.knownContentConsumer"));
        value.setKnownContentConsumers(knownContentConsumers);
        ArrayList<String> invalidContentConsumers = new ArrayList<String>();
        invalidContentConsumers.addAll(registry.getList(prefix + "invalidContentConsumers.invalidContentConsumer"));
        value.setInvalidContentConsumers(invalidContentConsumers);
        return value;
    }

    private FileType readFileType(String prefix, Registry registry) {
        FileType value = new FileType();
        List idList = registry.getList(prefix + "id");
        String id = value.getId();
        if (idList != null && !idList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = idList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)idList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            id = sb.toString();
        }
        value.setId(id);
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.addAll(registry.getList(prefix + "patterns.pattern"));
        value.setPatterns(patterns);
        return value;
    }

    private OrganisationInformation readOrganisationInformation(String prefix, Registry registry) {
        OrganisationInformation value = new OrganisationInformation();
        List nameList = registry.getList(prefix + "name");
        String name = value.getName();
        if (nameList != null && !nameList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = nameList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)nameList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            name = sb.toString();
        }
        value.setName(name);
        List urlList = registry.getList(prefix + "url");
        String url = value.getUrl();
        if (urlList != null && !urlList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = urlList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)urlList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            url = sb.toString();
        }
        value.setUrl(url);
        List logoLocationList = registry.getList(prefix + "logoLocation");
        String logoLocation = value.getLogoLocation();
        if (logoLocationList != null && !logoLocationList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = logoLocationList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)logoLocationList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            logoLocation = sb.toString();
        }
        value.setLogoLocation(logoLocation);
        return value;
    }

    private WebappConfiguration readWebappConfiguration(String prefix, Registry registry) {
        WebappConfiguration value = new WebappConfiguration();
        UserInterfaceOptions ui = this.readUserInterfaceOptions(prefix + "ui.", registry);
        value.setUi(ui);
        return value;
    }

    private UserInterfaceOptions readUserInterfaceOptions(String prefix, Registry registry) {
        UserInterfaceOptions value = new UserInterfaceOptions();
        boolean showFindArtifacts = registry.getBoolean(prefix + "showFindArtifacts", value.isShowFindArtifacts());
        value.setShowFindArtifacts(showFindArtifacts);
        boolean appletFindEnabled = registry.getBoolean(prefix + "appletFindEnabled", value.isAppletFindEnabled());
        value.setAppletFindEnabled(appletFindEnabled);
        boolean disableEasterEggs = registry.getBoolean(prefix + "disableEasterEggs", value.isDisableEasterEggs());
        value.setDisableEasterEggs(disableEasterEggs);
        List applicationUrlList = registry.getList(prefix + "applicationUrl");
        String applicationUrl = value.getApplicationUrl();
        if (applicationUrlList != null && !applicationUrlList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = applicationUrlList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)applicationUrlList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            applicationUrl = sb.toString();
        }
        value.setApplicationUrl(applicationUrl);
        boolean disableRegistration = registry.getBoolean(prefix + "disableRegistration", value.isDisableRegistration());
        value.setDisableRegistration(disableRegistration);
        return value;
    }

    private NetworkConfiguration readNetworkConfiguration(String prefix, Registry registry) {
        NetworkConfiguration value = new NetworkConfiguration();
        int maxTotal = registry.getInt(prefix + "maxTotal", value.getMaxTotal());
        value.setMaxTotal(maxTotal);
        int maxTotalPerHost = registry.getInt(prefix + "maxTotalPerHost", value.getMaxTotalPerHost());
        value.setMaxTotalPerHost(maxTotalPerHost);
        boolean usePooling = registry.getBoolean(prefix + "usePooling", value.isUsePooling());
        value.setUsePooling(usePooling);
        return value;
    }

    private ArchivaRuntimeConfiguration readArchivaRuntimeConfiguration(String prefix, Registry registry) {
        ArchivaRuntimeConfiguration value = new ArchivaRuntimeConfiguration();
        CacheConfiguration urlFailureCacheConfiguration = this.readCacheConfiguration(prefix + "urlFailureCacheConfiguration.", registry);
        value.setUrlFailureCacheConfiguration(urlFailureCacheConfiguration);
        return value;
    }

    private RedbackRuntimeConfiguration readRedbackRuntimeConfiguration(String prefix, Registry registry) {
        RedbackRuntimeConfiguration value = new RedbackRuntimeConfiguration();
        boolean migratedFromRedbackConfiguration = registry.getBoolean(prefix + "migratedFromRedbackConfiguration", value.isMigratedFromRedbackConfiguration());
        value.setMigratedFromRedbackConfiguration(migratedFromRedbackConfiguration);
        ArrayList<String> userManagerImpls = new ArrayList<String>();
        userManagerImpls.addAll(registry.getList(prefix + "userManagerImpls.userManagerImpl"));
        value.setUserManagerImpls(userManagerImpls);
        ArrayList<String> rbacManagerImpls = new ArrayList<String>();
        rbacManagerImpls.addAll(registry.getList(prefix + "rbacManagerImpls.rbacManagerImpl"));
        value.setRbacManagerImpls(rbacManagerImpls);
        LdapConfiguration ldapConfiguration = this.readLdapConfiguration(prefix + "ldapConfiguration.", registry);
        value.setLdapConfiguration(ldapConfiguration);
        ArrayList<LdapGroupMapping> ldapGroupMappings = new ArrayList<LdapGroupMapping>();
        List ldapGroupMappingsSubsets = registry.getSubsetList(prefix + "ldapGroupMappings.ldapGroupMapping");
        Iterator i = ldapGroupMappingsSubsets.iterator();
        while (i.hasNext()) {
            LdapGroupMapping v = this.readLdapGroupMapping("", (Registry)i.next());
            ldapGroupMappings.add(v);
        }
        value.setLdapGroupMappings(ldapGroupMappings);
        Properties configurationProperties = registry.getProperties(prefix + "configurationProperties");
        value.setConfigurationProperties(configurationProperties);
        boolean useUsersCache = registry.getBoolean(prefix + "useUsersCache", value.isUseUsersCache());
        value.setUseUsersCache(useUsersCache);
        CacheConfiguration usersCacheConfiguration = this.readCacheConfiguration(prefix + "usersCacheConfiguration.", registry);
        value.setUsersCacheConfiguration(usersCacheConfiguration);
        return value;
    }

    private LdapConfiguration readLdapConfiguration(String prefix, Registry registry) {
        LdapConfiguration value = new LdapConfiguration();
        List hostNameList = registry.getList(prefix + "hostName");
        String hostName = value.getHostName();
        if (hostNameList != null && !hostNameList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = hostNameList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)hostNameList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            hostName = sb.toString();
        }
        value.setHostName(hostName);
        int port = registry.getInt(prefix + "port", value.getPort());
        value.setPort(port);
        boolean ssl = registry.getBoolean(prefix + "ssl", value.isSsl());
        value.setSsl(ssl);
        List baseDnList = registry.getList(prefix + "baseDn");
        String baseDn = value.getBaseDn();
        if (baseDnList != null && !baseDnList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = baseDnList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)baseDnList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            baseDn = sb.toString();
        }
        value.setBaseDn(baseDn);
        List baseGroupsDnList = registry.getList(prefix + "baseGroupsDn");
        String baseGroupsDn = value.getBaseGroupsDn();
        if (baseGroupsDnList != null && !baseGroupsDnList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = baseGroupsDnList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)baseGroupsDnList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            baseGroupsDn = sb.toString();
        }
        value.setBaseGroupsDn(baseGroupsDn);
        List contextFactoryList = registry.getList(prefix + "contextFactory");
        String contextFactory = value.getContextFactory();
        if (contextFactoryList != null && !contextFactoryList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = contextFactoryList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)contextFactoryList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            contextFactory = sb.toString();
        }
        value.setContextFactory(contextFactory);
        List bindDnList = registry.getList(prefix + "bindDn");
        String bindDn = value.getBindDn();
        if (bindDnList != null && !bindDnList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = bindDnList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)bindDnList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            bindDn = sb.toString();
        }
        value.setBindDn(bindDn);
        List passwordList = registry.getList(prefix + "password");
        String password = value.getPassword();
        if (passwordList != null && !passwordList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = passwordList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)passwordList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            password = sb.toString();
        }
        value.setPassword(password);
        List authenticationMethodList = registry.getList(prefix + "authenticationMethod");
        String authenticationMethod = value.getAuthenticationMethod();
        if (authenticationMethodList != null && !authenticationMethodList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = authenticationMethodList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)authenticationMethodList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            authenticationMethod = sb.toString();
        }
        value.setAuthenticationMethod(authenticationMethod);
        boolean bindAuthenticatorEnabled = registry.getBoolean(prefix + "bindAuthenticatorEnabled", value.isBindAuthenticatorEnabled());
        value.setBindAuthenticatorEnabled(bindAuthenticatorEnabled);
        boolean writable = registry.getBoolean(prefix + "writable", value.isWritable());
        value.setWritable(writable);
        boolean useRoleNameAsGroup = registry.getBoolean(prefix + "useRoleNameAsGroup", value.isUseRoleNameAsGroup());
        value.setUseRoleNameAsGroup(useRoleNameAsGroup);
        Properties extraProperties = registry.getProperties(prefix + "extraProperties");
        value.setExtraProperties(extraProperties);
        return value;
    }

    private CacheConfiguration readCacheConfiguration(String prefix, Registry registry) {
        CacheConfiguration value = new CacheConfiguration();
        int timeToIdleSeconds = registry.getInt(prefix + "timeToIdleSeconds", value.getTimeToIdleSeconds());
        value.setTimeToIdleSeconds(timeToIdleSeconds);
        int timeToLiveSeconds = registry.getInt(prefix + "timeToLiveSeconds", value.getTimeToLiveSeconds());
        value.setTimeToLiveSeconds(timeToLiveSeconds);
        int maxElementsInMemory = registry.getInt(prefix + "maxElementsInMemory", value.getMaxElementsInMemory());
        value.setMaxElementsInMemory(maxElementsInMemory);
        int maxElementsOnDisk = registry.getInt(prefix + "maxElementsOnDisk", value.getMaxElementsOnDisk());
        value.setMaxElementsOnDisk(maxElementsOnDisk);
        return value;
    }

    private LdapGroupMapping readLdapGroupMapping(String prefix, Registry registry) {
        LdapGroupMapping value = new LdapGroupMapping();
        List groupList = registry.getList(prefix + "group");
        String group = value.getGroup();
        if (groupList != null && !groupList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            int size = groupList.size();
            for (int i = 0; i < size; ++i) {
                sb.append((String)groupList.get(i));
                if (i >= size - 1) continue;
                sb.append(',');
            }
            group = sb.toString();
        }
        value.setGroup(group);
        ArrayList<String> roleNames = new ArrayList<String>();
        roleNames.addAll(registry.getList(prefix + "roleNames.roleName"));
        value.setRoleNames(roleNames);
        return value;
    }
}

